<?php
require_once 'includes/seguridad.php';
if (!puede('ver_afiliaciones')) { header('Location: inicio.php?error=acceso_denegado'); exit(); }
$page_title = 'Gestión de Afiliaciones';
include_once 'templates/header.php';
?>

<style>
/* Estilos para la tabla y estados */
.estado-activo { color: #198754; font-weight: bold; }
.estado-inactivo, .estado-moroso, .estado-cancelado { color: #dc3545; font-weight: bold; }
.estado-vencido { color: #fd7e14; font-weight: bold; }
.estado-suspendido { color: #6c757d; font-weight: bold; }
.estado-proximo-a-vencer { color: #ffc107; font-weight: bold; }
.estado-pendiente { color: #0dcaf0; font-weight: bold; }

/* Estilos Modales */
.ami-modal-theme .modal-xl { max-width: 95vw !important; width: 95vw !important; margin: 1rem auto !important; }
.ami-modal-theme .modal-lg { max-width: 85vw !important; width: 85vw !important; margin: 1rem auto !important; }
.nav-pills .nav-link { background-color: rgba(0,0,0,0.2); color: var(--light-text); margin-right: 0.5rem; }
.nav-pills .nav-link.active { background-color: var(--primary-color); color: var(--dark-text); font-weight: bold; }

/* Estilos Detalle y Miembros */
.detalle-titulo { font-weight: bold; color: var(--primary-color); border-bottom: 1px solid var(--border-color); padding-bottom: 0.5rem; margin-bottom: 1rem; }
.detalle-linea { display: flex; justify-content: space-between; padding: 0.25rem 0; }
#miembros-container { max-height: 400px; overflow-y: auto; padding-right: 10px; }
.miembro-item { display: grid; grid-template-columns: 1fr 1fr 1fr 1fr 1fr 60px; gap: 1rem; align-items: center; margin-bottom: 0.75rem; padding: 0.5rem; border: 1px solid var(--border-color); border-radius: 0.375rem; }
.miembro-item.titular-row { background-color: rgba(0,0,0,0.05); border-color: var(--primary-color); }

/* Estilos Controles */
.btn-group-tipo-contrato .btn { border-radius: 0; }
.btn-group-tipo-contrato .btn:first-child { border-top-left-radius: .375rem; border-bottom-left-radius: .375rem; }
.btn-group-tipo-contrato .btn:last-child { border-top-right-radius: .375rem; border-bottom-right-radius: .375rem; }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <?php if (puede('gestionar_afiliaciones')): ?>
        <button class="btn-add-new" id="btn-nueva-afiliacion"><i class="fa-solid fa-plus"></i> Nueva Afiliación</button>
    <?php endif; ?>
</div>

<div class="info-card">
    <div class="toolbar mb-3">
        <input type="text" id="searchInput" class="form-control form-control-dark" placeholder="Buscar por Contrato, Nombre, Cédula o Empresa...">
    </div>
    <div class="table-responsive">
        <table class="ami-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>N° Contrato</th>
                    <th>Titular / Empresa</th>
                    <th>Cédula / RIF</th>
                    <th>Último Pago</th>
                    <th>Vencimiento</th>
                    <th class="text-center">Miembros</th>
                    <th class="text-center">Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="tabla-afiliaciones"></tbody>
        </table>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalAfiliacion" tabindex="-1">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalAfiliacionTitle">Nueva Afiliación</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="formAfiliacion">
            <input type="hidden" name="afiliacion_id" id="afiliacion_id">
            <input type="hidden" name="tipo_contrato" id="tipo_contrato" value="Personal">
            <div class="mb-4 text-center">
                <label class="form-label">Tipo de Contrato</label>
                <div class="btn-group btn-group-tipo-contrato" role="group">
                    <button type="button" class="btn btn-primary" id="btn-tipo-personal"><i class="fa-solid fa-user"></i> Personal</button>
                    <button type="button" class="btn btn-outline-primary" id="btn-tipo-empresarial"><i class="fa-solid fa-building"></i> Empresarial</button>
                </div>
            </div>
            <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation"><a class="nav-link active" data-bs-toggle="pill" href="#tab-titular">1. Datos Principales</a></li>
                <li class="nav-item" role="presentation"><a class="nav-link" data-bs-toggle="pill" href="#tab-plan">2. Detalles del Plan</a></li>
                <li class="nav-item" role="presentation"><a class="nav-link" data-bs-toggle="pill" href="#tab-miembros">3. Miembros</a></li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane fade show active" id="tab-titular">
                    <div class="row" id="campos-empresa" style="display: none;">
                        <div class="col-md-6 mb-3"><label class="ami-form-label">Nombre de la Empresa</label><input type="text" name="nombre_empresa" class="form-control"></div>
                        <div class="col-md-6 mb-3"><label class="ami-form-label">RIF de la Empresa</label><input type="text" name="rif_empresa" class="form-control"></div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3"><label class="ami-form-label" id="label-contrato">Número de Contrato</label><input type="text" name="numero_contrato" class="form-control" required></div>
                        <div class="col-md-3 mb-3"><label class="ami-form-label" id="label-nombre">Nombres</label><input type="text" name="nombre_titular" id="nombre_titular" class="form-control" required></div>
                        <div class="col-md-3 mb-3"><label class="ami-form-label" id="label-apellido">Apellidos</label><input type="text" name="apellido_titular" id="apellido_titular" class="form-control" required></div>
                        <div class="col-md-3 mb-3"><label class="ami-form-label" id="label-cedula">Cédula</label><input type="text" name="cedula_titular" id="cedula_titular" class="form-control" required></div>
                        <div class="col-md-3 mb-3"><label class="ami-form-label">Teléfono Celular</label><input type="text" name="telefono_titular" class="form-control" required></div>
                        <div class="col-md-3 mb-3"><label class="ami-form-label">Teléfono Casa</label><input type="text" name="telefono_casa_titular" class="form-control"></div>
                        <div class="col-md-3 mb-3"><label class="ami-form-label">Ciudad</label><input type="text" name="ciudad" class="form-control"></div>
                        <div class="col-md-3 mb-3"><label class="ami-form-label">Sede</label><select name="sede_id" id="select-sede" class="form-select"></select></div>
                        <div class="col-md-12 mb-3"><label class="ami-form-label">Dirección Completa</label><textarea name="direccion_titular" class="form-control" rows="2" required></textarea></div>
                    </div>
                </div>
                <div class="tab-pane fade" id="tab-plan">
                    <div class="row">
                        <div class="col-md-4 mb-3"><label class="ami-form-label">Plan de Afiliación</label><select name="plan_id" id="select-plan" class="form-select" required><option value="">Seleccione un tipo de contrato</option></select></div>
                        <div class="col-md-4 mb-3"><label class="ami-form-label">Fecha de Inscripción</label><input type="date" name="fecha_inscripcion" class="form-control" required></div>
                        <div class="col-md-4 mb-3"><label class="ami-form-label">Estado Manual del Contrato</label><select name="estado" class="form-select"><option value="Activo">Activo</option><option value="Suspendido">Suspendido</option><option value="Cancelado">Cancelado</option></select></div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12"><div class="alert alert-info text-center"><h4>Costo Mensual Calculado: <strong id="costo-calculado-display">$0.00</strong></h4><small id="costo-calculado-detalle"></small></div></div>
                    </div>
                </div>
                <div class="tab-pane fade" id="tab-miembros">
                    <div class="d-flex justify-content-between align-items-center">
                        <div><p class="mb-1">Total de miembros (incluyendo titular): <strong id="contador-miembros-actuales" class="text-primary fs-4">0</strong></p><small class="text-muted">El costo del plan se recalcula automáticamente.</small></div>
                        <button type="button" class="btn btn-info" id="btn-gestionar-miembros" disabled><i class="fa-solid fa-users-cog"></i> Gestionar Miembros</button>
                    </div>
                </div>
            </div>
        </form>
      </div>
      <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-solid fa-times"></i> Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarAfiliacion"><i class="fa-solid fa-save"></i> Guardar Cambios</button></div>
    </div>
  </div>
</div>

<div class="modal fade ami-modal-theme" id="modalGestionarMiembros" tabindex="-1">
    <div class="modal-dialog modal-xl"><div class="modal-content">
        <div class="modal-header"><h5 class="modal-title"><i class="fa-solid fa-users"></i> Gestionar Miembros de <span id="titular-miembros-modal" class="text-primary"></span></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
        <div class="modal-body">
            <form id="formMiembros">
                <input type="hidden" name="afiliacion_id_miembros" id="afiliacion_id_miembros">
                <div class="miembro-item" style="background-color: var(--primary-color); color: white; font-weight: bold;"><div>Nombres *</div><div>Apellidos *</div><div>Cédula</div><div>Fecha Nac.</div><div>Parentesco</div><div class="text-center">Acción</div></div>
                <div id="miembros-container"></div>
                <div class="mt-3"><button type="button" class="btn btn-outline-success" id="btn-agregar-miembro-fila"><i class="fa-solid fa-plus"></i> Añadir Miembro</button></div>
            </form>
        </div>
        <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button><button type="button" class="btn btn-primary" id="btnGuardarMiembros"><i class="fa-solid fa-save"></i> Guardar Miembros</button></div>
    </div></div>
</div>

<div class="modal fade ami-modal-theme" id="modalVerDetalles" tabindex="-1">
    <div class="modal-dialog modal-lg"><div class="modal-content">
        <div class="modal-header"><h5 class="modal-title"><i class="fa-solid fa-eye"></i> Detalles del Contrato</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
        <div class="modal-body" id="detalles-body-container"></div>
        <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
    </div></div>
</div>

<div class="modal fade ami-modal-theme" id="modalRegistrarPago" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered"><div class="modal-content">
      <div class="modal-header"><h5 class="modal-title"><i class="fa-solid fa-cash-register"></i> Registrar Pago para <strong id="pago-nombre-cliente" class="text-primary"></strong></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
      <div class="modal-body">
        <form id="formRegistrarPago">
            <input type="hidden" id="pago-afiliacion-id" name="afiliacion_id">
            <div class="alert alert-info">Plan: <strong id="pago-plan-actual">--</strong><br>Vencimiento Actual: <strong id="pago-vencimiento-actual">--</strong><hr><div class="text-center">Monto Mensual: <strong class="fs-4" id="pago-monto-sugerido">$0.00</strong></div></div>
            <div class="row">
                <div class="col-md-6 mb-3"><label class="ami-form-label">Cantidad de Meses</label><input type="number" id="pago-cantidad-meses" name="cantidad_meses" class="form-control" value="1" min="1" data-costo-base="0"></div>
                <div class="col-md-6 mb-3"><label class="ami-form-label">Monto a Pagar (USD)</label><input type="number" step="0.01" name="monto_pagado" class="form-control" required></div>
            </div>
            <div class="mb-3"><label class="ami-form-label">Fecha del Pago</label><input type="date" name="fecha_pago" class="form-control" required></div>
            <div class="row">
                <div class="col-md-6 mb-3"><label class="ami-form-label">Método de Pago</label><select name="metodo_pago" id="metodo_pago" class="form-select"><option value="Divisa">Divisa</option><option value="Efectivo Bs">Efectivo Bs</option><option value="Pago Móvil">Pago Móvil</option><option value="Transferencia">Transferencia</option><option value="Zelle">Zelle</option><option value="Punto de Venta">Punto de Venta</option></select></div>
                <div class="col-md-6 mb-3"><label class="ami-form-label">Nº Referencia</label><input type="text" name="referencia" class="form-control"></div>
            </div>
            <div class="mb-3" id="campo-monto-bs" style="display: none;">
                <label class="ami-form-label">Monto en Bs.</label>
                <input type="number" step="0.01" name="monto_bs" class="form-control" placeholder="Ingrese el monto exacto en Bolívares">
            </div>
        </form>
      </div>
      <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarPago"><i class="fa-solid fa-save"></i> Guardar Pago</button></div>
  </div></div>
</div>

<div class="modal fade ami-modal-theme" id="modalClaveAdmin" data-bs-backdrop="static" tabindex="-1">
    <div class="modal-dialog modal-sm modal-dialog-centered"><div class="modal-content">
        <div class="modal-header"><h5 class="modal-title"><i class="fa-solid fa-shield-alt"></i> Confirmación Requerida</h5></div>
        <div class="modal-body"><p>Por seguridad, ingrese la clave maestra para confirmar.</p><input type="password" id="input-clave-admin" class="form-control" placeholder="Clave Maestra"></div>
        <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnConfirmarClave">Proceder</button></div>
    </div></div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const modales = {
        afiliacion: new bootstrap.Modal(document.getElementById('modalAfiliacion')),
        miembros: new bootstrap.Modal(document.getElementById('modalGestionarMiembros')),
        detalles: new bootstrap.Modal(document.getElementById('modalVerDetalles')),
        pago: new bootstrap.Modal(document.getElementById('modalRegistrarPago')),
        clave: new bootstrap.Modal(document.getElementById('modalClaveAdmin'))
    };
    const formAfiliacion = document.getElementById('formAfiliacion');
    const tablaBody = document.getElementById('tabla-afiliaciones');
    const searchInput = document.getElementById('searchInput');
    let searchTimeout, afterKeyVerification, planesDisponibles = [], miembrosActuales = [];

    const fetchAPI = (url, options = {}) => fetch(url, options).then(res => res.json());

    const cargarAfiliaciones = () => {
        tablaBody.innerHTML = `<tr><td colspan="9" class="text-center">Cargando...</td></tr>`;
        fetchAPI(`/api/afiliaciones_ajax.php?action=cargar_afiliaciones&search=${searchInput.value}`).then(data => renderizarTabla(data.success ? data.data : []));
    };

    const renderizarTabla = (afiliaciones) => {
        tablaBody.innerHTML = '';
        if (afiliaciones.length === 0) {
            tablaBody.innerHTML = `<tr><td colspan="9" class="text-center">No se encontraron afiliaciones.</td></tr>`;
            return;
        }
        const statusMap = { 'Activo': 'estado-activo', 'Vencido': 'estado-vencido', 'Moroso': 'estado-moroso', 'Próximo a Vencer': 'estado-proximo-a-vencer', 'Suspendido': 'estado-suspendido', 'Cancelado': 'estado-cancelado', 'Pendiente': 'estado-pendiente' };
        let contador = 1;
        afiliaciones.forEach(a => {
            const titular = a.tipo_contrato === 'Empresarial' ? a.nombre_empresa : `${a.nombre_titular} ${a.apellido_titular}`;
            const identificador = a.tipo_contrato === 'Empresarial' ? (a.rif_empresa || 'N/A') : a.cedula_titular;
            const vencimiento = a.fecha_vencimiento ? new Date(a.fecha_vencimiento + 'T00:00:00').toLocaleDateString('es-ES') : 'N/A';
            const statusClass = statusMap[a.estado] || '';
            const ultimoPago = a.ultima_fecha_pago ? new Date(a.ultima_fecha_pago + 'T00:00:00').toLocaleDateString('es-ES') : '<span class="text-muted">N/A</span>';
            const accionesHtml = `<div class="d-flex gap-2">
                <button class="btn btn-sm btn-info" onclick="window.abrirModalVerDetalles(${a.id})" title="Ver Detalles"><i class="fa-solid fa-eye"></i></button>
                <button class="btn btn-sm btn-success" onclick="window.abrirModalPago(${a.id})" title="Registrar Pago"><i class="fa-solid fa-dollar-sign"></i></button>
                <button class="btn btn-sm btn-warning" onclick="window.abrirHistorialPagos(${a.id})" title="Historial de Pagos"><i class="fa-solid fa-receipt"></i></button>
                <?php if (puede('gestionar_afiliaciones')): ?><button class="btn btn-sm btn-outline-light" onclick="window.abrirModalParaEditar(${a.id})" title="Editar"><i class="fa-solid fa-pencil"></i></button><?php endif; ?></div>`;
            tablaBody.innerHTML += `<tr>
                <td>${contador++}</td>
                <td>${a.numero_contrato}</td>
                <td><strong>${titular}</strong></td>
                <td>${identificador}</td>
                <td>${ultimoPago}</td>
                <td>${vencimiento}</td>
                <td class="text-center">${1 + parseInt(a.total_miembros)}</td>
                <td class="text-center"><span class="${statusClass}">${a.estado}</span></td>
                <td>${accionesHtml}</td>
            </tr>`;
        });
    };
    
    window.abrirHistorialPagos = function(id) {
        solicitarClaveAdmin(() => {
            window.location.href = `pagos-detalles.php?id=${id}`;
        });
    };
    
    const cambiarTipoContratoUI = (tipo) => {
        document.getElementById('tipo_contrato').value = tipo;
        const esEmpresarial = tipo === 'Empresarial';
        document.getElementById('btn-tipo-personal').classList.toggle('btn-primary', !esEmpresarial);
        document.getElementById('btn-tipo-personal').classList.toggle('btn-outline-primary', esEmpresarial);
        document.getElementById('btn-tipo-empresarial').classList.toggle('btn-primary', esEmpresarial);
        document.getElementById('btn-tipo-empresarial').classList.toggle('btn-outline-primary', !esEmpresarial);
        document.getElementById('campos-empresa').style.display = esEmpresarial ? '' : 'none';
        ['nombre', 'apellido', 'cedula'].forEach(l => document.getElementById(`label-${l}`).textContent = esEmpresarial ? `${l.charAt(0).toUpperCase() + l.slice(1)} del Contacto` : `${l.charAt(0).toUpperCase() + l.slice(1)}s`);
        cargarPlanes(tipo);
    };

    const cargarPlanes = (tipo, planSeleccionadoId = null) => {
        const selectPlan = document.getElementById('select-plan');
        selectPlan.innerHTML = '<option value="">Cargando...</option>';
        fetchAPI('/api/afiliaciones_ajax.php?action=cargar_planes').then(data => {
            if (data.success) {
                planesDisponibles = data.data;
                const planesFiltrados = planesDisponibles.filter(p => p.tipo_plan === tipo);
                selectPlan.innerHTML = '<option value="">-- Seleccione un Plan --</option>';
                planesFiltrados.forEach(p => selectPlan.innerHTML += `<option value="${p.id}">${p.nombre}</option>`);
                if (planSeleccionadoId) {
                    selectPlan.value = planSeleccionadoId;
                }
                calcularCostoTotal();
                actualizarEstadoBotonMiembros();
            }
        });
    };

    const calcularCostoTotal = () => {
        const planId = document.getElementById('select-plan').value;
        const plan = planesDisponibles.find(p => p.id == planId);
        const totalMiembros = 1 + miembrosActuales.length; 
        let costo = 0, detalle = '';
        if (plan) {
            costo = (plan.tipo_plan === 'Empresarial') ? totalMiembros * parseFloat(plan.costo_miembro_extra) : parseFloat(plan.costo_mensual);
            detalle = (plan.tipo_plan === 'Empresarial') ? `${totalMiembros} persona(s) a $${plan.costo_miembro_extra} c/u` : `Costo base: $${costo.toFixed(2)}`;
            if (plan.tipo_plan === 'Personal' && totalMiembros > plan.miembros_max && parseFloat(plan.costo_miembro_extra) > 0) {
                const miembrosExtra = totalMiembros - plan.miembros_max;
                const costoExtra = miembrosExtra * parseFloat(plan.costo_miembro_extra);
                costo += costoExtra;
                detalle += ` + ${miembrosExtra} miembro(s) extra a $${plan.costo_miembro_extra} c/u`;
            }
        }
        document.getElementById('costo-calculado-display').textContent = `$${costo.toFixed(2)}`;
        document.getElementById('costo-calculado-detalle').textContent = detalle;
        document.getElementById('contador-miembros-actuales').textContent = totalMiembros;
    };
    
    const actualizarEstadoBotonMiembros = () => {
        const btnAgregar = document.getElementById('btn-agregar-miembro-fila');
        const planId = document.getElementById('select-plan').value;
        if (!planId || !planesDisponibles.length) {
            btnAgregar.disabled = true;
            return;
        }

        const plan = planesDisponibles.find(p => p.id == planId);
        if (!plan) {
            btnAgregar.disabled = true;
            return;
        }
        
        const totalMiembros = document.querySelectorAll('#miembros-container .miembro-item').length;
        const maxMiembros = parseInt(plan.miembros_max);
        const tieneCostoExtra = parseFloat(plan.costo_miembro_extra) > 0;

        if (tieneCostoExtra) {
            btnAgregar.disabled = false;
        } else {
            btnAgregar.disabled = totalMiembros >= maxMiembros;
        }
    };

    const agregarMiembro = (miembro = {}) => {
        const container = document.getElementById('miembros-container');
        const index = 'new_' + Date.now();
        const miembroHtml = `<div class="miembro-item" id="miembro-${index}">
            <input type="hidden" name="miembros[${index}][id]" value="${miembro.id || ''}">
            <input type="text" name="miembros[${index}][nombre]" class="form-control" placeholder="Nombres" value="${miembro.nombre || ''}" required>
            <input type="text" name="miembros[${index}][apellido]" class="form-control" placeholder="Apellidos" value="${miembro.apellido || ''}" required>
            <input type="text" name="miembros[${index}][cedula]" class="form-control" placeholder="Cédula" value="${miembro.cedula || ''}">
            <input type="date" name="miembros[${index}][fecha_nacimiento]" class="form-control" value="${miembro.fecha_nacimiento || ''}">
            <input type="text" name="miembros[${index}][parentesco]" class="form-control" placeholder="Parentesco" value="${miembro.parentesco || ''}">
            <button type="button" class="btn btn-sm btn-danger" onclick="this.closest('.miembro-item').remove(); actualizarEstadoBotonMiembros();" title="Eliminar"><i class="fa-solid fa-trash"></i></button>
        </div>`;
        container.insertAdjacentHTML('beforeend', miembroHtml);
        actualizarEstadoBotonMiembros();
    };

    const ejecutarGuardarMiembros = () => {
        const form = document.getElementById('formMiembros');
        const formData = new FormData(form);
        formData.append('action', 'gestionar_miembros');
        formData.append('csrf_token', csrfToken);
        fetchAPI('/api/afiliaciones_ajax.php', { method: 'POST', body: formData }).then(data => {
            if (data.success) {
                modales.miembros.hide();
                Swal.fire('¡Éxito!', data.message, 'success');
                abrirModalParaEditar(form.afiliacion_id_miembros.value);
                cargarAfiliaciones();
            } else Swal.fire('Error', data.message, 'error');
        });
    };

    window.abrirModalParaEditar = (id) => {
        fetchAPI(`/api/afiliaciones_ajax.php?action=obtener_afiliacion&id=${id}`).then(data => {
            if (data.success) {
                const a = data.data;
                formAfiliacion.reset();
                Object.keys(a).forEach(key => { if (formAfiliacion.elements[key]) formAfiliacion.elements[key].value = a[key]; });
                document.getElementById('afiliacion_id').value = a.id;
                miembrosActuales = a.miembros;
                cambiarTipoContratoUI(a.tipo_contrato);
                cargarSedes(a.sede_id);
                cargarPlanes(a.tipo_contrato, a.plan_id);
                document.getElementById('modalAfiliacionTitle').textContent = `Editando Contrato N° ${a.numero_contrato}`;
                document.getElementById('btn-gestionar-miembros').disabled = false;
                modales.afiliacion.show();
            } else Swal.fire('Error', data.message, 'error');
        });
    };

    window.abrirModalPago = (id) => {
        const form = document.getElementById('formRegistrarPago');
        form.reset(); 
        document.getElementById('campo-monto-bs').style.display = 'none';
        document.getElementById('pago-afiliacion-id').value = id;
        
        fetchAPI(`/api/afiliaciones_ajax.php?action=obtener_afiliacion&id=${id}`).then(data => {
            if (data.success) {
                const a = data.data;
                const costoSugerido = a.calculo ? parseFloat(a.calculo.costo_total_mensual) : 0;
                document.getElementById('pago-nombre-cliente').textContent = a.nombre_empresa || `${a.nombre_titular} ${a.apellido_titular}`;
                document.getElementById('pago-plan-actual').textContent = a.nombre_plan || 'No asignado';
                document.getElementById('pago-vencimiento-actual').textContent = new Date(a.fecha_vencimiento + 'T00:00:00').toLocaleDateString('es-ES');
                document.getElementById('pago-monto-sugerido').textContent = `$${costoSugerido.toFixed(2)}`;
                document.getElementById('pago-cantidad-meses').dataset.costoBase = costoSugerido;
                form.querySelector('[name="monto_pagado"]').value = costoSugerido.toFixed(2);
                form.querySelector('[name="fecha_pago"]').valueAsDate = new Date();
                modales.pago.show();
            } else Swal.fire('Error', 'No se pudieron cargar los datos.', 'error');
        });
    };

    window.abrirModalVerDetalles = function(id) {
        fetchAPI(`/api/afiliaciones_ajax.php?action=obtener_afiliacion&id=${id}`).then(data => {
            if(data.success){
                const a = data.data;
                const miembrosHtml = a.miembros.length > 0 ? a.miembros.map(m => `<li>${m.nombre} ${m.apellido} (C.I: ${m.cedula || 'N/A'}, Parentesco: ${m.parentesco || 'N/A'})</li>`).join('') : '<li>No hay miembros adicionales.</li>';
                const facturacionHtml = a.calculo ? `
                    <div class="detalle-grupo">
                        <h6 class="detalle-titulo">Detalles de Facturación</h6>
                        <div class="detalle-linea"><span>Costo Base del Plan:</span> <strong>$${parseFloat(a.calculo.costo_base).toFixed(2)}</strong></div>
                        ${a.calculo.miembros_extra > 0 ? `
                        <div class="detalle-linea"><span>Miembros Extra (${a.calculo.miembros_extra}):</span> <strong>$${parseFloat(a.calculo.costo_total_extra).toFixed(2)}</strong></div>
                        ` : ''}
                        <div class="detalle-linea fs-5"><span>Costo Total Mensual:</span> <strong class="text-primary">$${parseFloat(a.calculo.costo_total_mensual).toFixed(2)}</strong></div>
                    </div>` : '';
                const detallesHtml = `
                    <div class="detalle-grupo"><h6 class="detalle-titulo">Datos del Contrato</h6>
                        <div class="detalle-linea"><span>N° Contrato:</span> <strong>${a.numero_contrato}</strong></div>
                        <div class="detalle-linea"><span>Plan Contratado:</span> <strong>${a.nombre_plan || 'No especificado'}</strong></div>
                        <div class="detalle-linea"><span>Sede:</span> <strong>${a.nombre_sede || 'No especificada'}</strong></div>
                        <div class="detalle-linea"><span>Inscripción:</span> <strong>${new Date(a.fecha_inscripcion + 'T00:00:00').toLocaleDateString('es-ES')}</strong></div>
                        <div class="detalle-linea"><span>Próximo Vencimiento:</span> <strong>${new Date(a.fecha_vencimiento + 'T00:00:00').toLocaleDateString('es-ES')}</strong></div>
                    </div>
                    ${facturacionHtml}
                    <div class="detalle-grupo"><h6 class="detalle-titulo">Datos del Titular/Empresa</h6>
                        <div class="detalle-linea"><span>${a.tipo_contrato === 'Empresarial' ? 'Empresa' : 'Titular'}:</span> <strong>${a.nombre_empresa || a.nombre_titular + ' ' + a.apellido_titular}</strong></div>
                        <div class="detalle-linea"><span>${a.tipo_contrato === 'Empresarial' ? 'RIF' : 'Cédula'}:</span> <strong>${a.rif_empresa || a.cedula_titular}</strong></div>
                        <div class="detalle-linea"><span>Teléfono:</span> <strong>${a.telefono_titular}</strong></div>
                        <div class="detalle-linea"><span>Dirección:</span> <strong>${a.direccion_titular}</strong></div>
                    </div>
                    <div class="detalle-grupo"><h6 class="detalle-titulo">Miembros Familiares</h6><ul>${miembrosHtml}</ul></div>`;
                document.getElementById('detalles-body-container').innerHTML = detallesHtml;
                modales.detalles.show();
            } else Swal.fire('Error', data.message, 'error');
        });
    }
    
    const solicitarClaveAdmin = (callback) => { afterKeyVerification = callback; document.getElementById('input-clave-admin').value = ''; modales.clave.show(); };
    
    // --- EVENT LISTENERS ---
    document.getElementById('btn-nueva-afiliacion').addEventListener('click', () => {
        formAfiliacion.reset(); document.getElementById('afiliacion_id').value = ''; miembrosActuales = [];
        document.getElementById('modalAfiliacionTitle').textContent = 'Nueva Afiliación';
        formAfiliacion.querySelector('[name="fecha_inscripcion"]').valueAsDate = new Date();
        document.getElementById('btn-gestionar-miembros').disabled = true;
        document.getElementById('contador-miembros-actuales').textContent = '1';
        cambiarTipoContratoUI('Personal');
        cargarSedes(); 
        modales.afiliacion.show();
    });
    document.getElementById('btn-tipo-personal').addEventListener('click', () => cambiarTipoContratoUI('Personal'));
    document.getElementById('btn-tipo-empresarial').addEventListener('click', () => cambiarTipoContratoUI('Empresarial'));
    
    document.getElementById('select-plan').addEventListener('change', () => {
        calcularCostoTotal();
        actualizarEstadoBotonMiembros();
    });

    document.getElementById('pago-cantidad-meses').addEventListener('input', function() {
        const costoBase = parseFloat(this.dataset.costoBase) || 0;
        const meses = parseInt(this.value) || 1;
        document.querySelector('#formRegistrarPago [name="monto_pagado"]').value = (costoBase * meses).toFixed(2);
    });

    searchInput.addEventListener('input', () => { clearTimeout(searchTimeout); searchTimeout = setTimeout(cargarAfiliaciones, 500); });
    
    document.getElementById('btnGuardarAfiliacion').addEventListener('click', () => solicitarClaveAdmin(() => {
        const formData = new FormData(formAfiliacion);
        formData.append('action', 'guardar_afiliacion');
        formData.append('csrf_token', csrfToken);
        fetchAPI('/api/afiliaciones_ajax.php', { method: 'POST', body: formData }).then(data => {
            if (data.success) { modales.afiliacion.hide(); Swal.fire('¡Éxito!', data.message, 'success'); cargarAfiliaciones(); } 
            else { Swal.fire('Error', data.message, 'error'); }
        });
    }));

    document.getElementById('btnGuardarPago').addEventListener('click', () => solicitarClaveAdmin(() => {
        const form = document.getElementById('formRegistrarPago');
        const formData = new FormData(form);
        formData.append('action', 'registrar_pago');
        formData.append('csrf_token', csrfToken);
        fetchAPI('/api/afiliaciones_ajax.php', { method: 'POST', body: formData }).then(data => {
            if(data.success) { modales.pago.hide(); Swal.fire('¡Éxito!', data.message, 'success'); cargarAfiliaciones(); } 
            else { Swal.fire('Error', data.message, 'error'); }
        });
    }));

    document.getElementById('btnConfirmarClave').addEventListener('click', function() {
        const clave = document.getElementById('input-clave-admin').value;
        if (!clave) { Swal.fire('Atención', 'Debe ingresar la clave.', 'warning'); return; }
        const formData = new FormData();
        formData.append('action', 'verificar_clave_maestra');
        formData.append('csrf_token', csrfToken);
        formData.append('clave_maestra', clave);
        fetchAPI('/api/afiliaciones_ajax.php', { method: 'POST', body: formData }).then(data => {
            if (data.success) { modales.clave.hide(); if (typeof afterKeyVerification === 'function') { afterKeyVerification(); } } 
            else { Swal.fire('Acceso Denegado', data.message, 'error'); }
        });
    });
    
    document.getElementById('btn-gestionar-miembros').addEventListener('click', function() {
        const afiliacionId = document.getElementById('afiliacion_id').value;
        const titularNombre = document.getElementById('nombre_titular').value;
        const titularApellido = document.getElementById('apellido_titular').value;
        const titularCedula = document.getElementById('cedula_titular').value;
        const titularNombreCompleto = `${titularNombre} ${titularApellido}`;

        if (afiliacionId) {
            document.getElementById('afiliacion_id_miembros').value = afiliacionId;
            document.getElementById('titular-miembros-modal').textContent = titularNombreCompleto;
            const container = document.getElementById('miembros-container');
            container.innerHTML = '';

            const titularHtml = `
            <div class="miembro-item titular-row">
                <input type="text" class="form-control" value="${titularNombre}" disabled>
                <input type="text" class="form-control" value="${titularApellido}" disabled>
                <input type="text" class="form-control" value="${titularCedula}" disabled>
                <input type="date" class="form-control" disabled>
                <input type="text" class="form-control" value="Titular" disabled>
                <div class="text-center"><i class="fa-solid fa-star text-warning" title="Titular del Contrato"></i></div>
            </div>`;
            container.insertAdjacentHTML('beforeend', titularHtml);

            miembrosActuales.forEach(miembro => agregarMiembro(miembro));
            actualizarEstadoBotonMiembros();
            modales.miembros.show();
        }
    });

    document.getElementById('btn-agregar-miembro-fila').addEventListener('click', () => agregarMiembro());
    document.getElementById('btnGuardarMiembros').addEventListener('click', () => solicitarClaveAdmin(ejecutarGuardarMiembros));

    document.getElementById('metodo_pago').addEventListener('change', function() {
        const campoMontoBs = document.getElementById('campo-monto-bs');
        const metodosEnBs = ['Efectivo Bs', 'Pago Móvil'];
        
        if (metodosEnBs.includes(this.value)) {
            campoMontoBs.style.display = 'block';
        } else {
            campoMontoBs.style.display = 'none';
            campoMontoBs.querySelector('input').value = '';
        }
    });

    // --- INICIALIZACIÓN ---
    cargarSedes();
    cargarPlanes('Personal');
    cargarAfiliaciones();
});

function cargarSedes(sedeSeleccionadaId = null) {
    fetch('/api/afiliaciones_ajax.php?action=get_sedes').then(res => res.json()).then(data => {
        if(data.success) {
            const select = document.getElementById('select-sede');
            select.innerHTML = '<option value="">-- Seleccione Sede --</option>';
            data.data.forEach(sede => select.innerHTML += `<option value="${sede.id}" ${sede.id == sedeSeleccionadaId ? 'selected' : ''}>${sede.nombre}</option>`);
        }
    });
}
</script>

<?php include_once 'templates/footer.php'; ?>