<?php
// RUTA CORREGIDA: Sube un nivel para encontrar la carpeta 'includes'
require_once '../includes/seguridad.php'; 
$page_title = 'Gestión de Roles y Permisos';
// RUTA CORREGIDA: Sube un nivel para encontrar la carpeta 'templates'
include_once '../templates/header.php';

if (!puede('gestionar_roles')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1><p>No tienes permiso para ver esta página.</p></div></main>";
    include_once '../templates/footer.php';
    exit();
}

$roles = $conn->query("SELECT id, nombre, clave FROM roles ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="info-card">
    <div id="lista-roles">
        <?php foreach ($roles as $rol): ?>
            <div class="rol-item">
                <div class="rol-info">
                    <strong><?php echo htmlspecialchars($rol['nombre']); ?></strong><br>
                    <span>(clave: <?php echo htmlspecialchars($rol['clave']); ?>)</span>
                </div>
                <div>
                    <?php if ($rol['clave'] !== 'superadmin'): ?>
                        <button class="btn btn-outline-light btn-sm" onclick="gestionarPermisos(<?php echo $rol['id']; ?>, '<?php echo htmlspecialchars($rol['nombre']); ?>')">
                            <i class="fa-solid fa-shield-halved"></i> Gestionar Permisos
                        </button>
                    <?php else: ?>
                        <span class="badge bg-success">Acceso Total</span>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<div class="ami-modal" id="modalPermisos">
  <div class="ami-modal-dialog">
    <div class="ami-modal-content">
      <div class="ami-modal-header">
        <h5 class="ami-modal-title">Permisos para <span id="nombreRolModal"></span></h5>
        <button type="button" class="ami-btn-close" onclick="ocultarModal('modalPermisos')">&times;</button>
      </div>
      <div class="ami-modal-body">
        <form id="formPermisos">
          <input type="hidden" name="action" value="guardar_permisos_rol">
          <input type="hidden" name="rol_id" id="rol_id_modal">
          <div id="permisos-container" class="permisos-container">
            <p>Cargando permisos...</p>
          </div>
          <hr style="border-color: var(--border-color); margin: 1.5rem 0;">
          <button type="submit" class="ami-btn ami-btn-primary">Guardar Cambios</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

function mostrarModal(id) { document.getElementById(id).classList.add('show'); }
function ocultarModal(id) { document.getElementById(id).classList.remove('show'); }

function gestionarPermisos(rolId, rolNombre) {
    document.getElementById('nombreRolModal').textContent = rolNombre;
    document.getElementById('rol_id_modal').value = rolId;
    const container = document.getElementById('permisos-container');
    container.innerHTML = '<p>Cargando permisos...</p>';
    
    mostrarModal('modalPermisos');

    fetch(`/api/roles_ajax.php?action=obtener_permisos_rol&rol_id=${rolId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                container.innerHTML = '';
                data.data.todos_permisos.forEach(permiso => {
                    const isChecked = data.data.permisos_actuales.includes(permiso.id);
                    container.innerHTML += `
                        <div class="form-check permiso-item">
                            <input class="form-check-input" type="checkbox" name="permisos[]" value="${permiso.id}" id="permiso-${permiso.id}" ${isChecked ? 'checked' : ''}>
                            <label class="form-check-label" for="permiso-${permiso.id}">
                                <strong>${permiso.clave}</strong>: <small>${permiso.descripcion}</small>
                            </label>
                        </div>
                    `;
                });
            } else {
                container.innerHTML = `<p style="color:red;">${data.message}</p>`;
            }
        });
}

document.getElementById('formPermisos').addEventListener('submit', function(e) {
    e.preventDefault();
    const formData = new FormData(this);
    formData.append('csrf_token', csrfToken);
    
    fetch('/api/roles_ajax.php', { method: 'POST', body: formData })
        .then(response => response.json())
        .then(data => {
            ocultarModal('modalPermisos');
            if(data.success) {
                Swal.fire('¡Éxito!', data.message, 'success');
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        });
});

document.querySelectorAll('.ami-modal-content').forEach(function(modalContent) {
    modalContent.addEventListener('click', function(event) {
        event.stopPropagation();
    });
});
document.querySelectorAll('.ami-modal').forEach(function(modal) {
    modal.addEventListener('click', function(event) {
        ocultarModal(this.id);
    });
});
</script>

<?php 
// RUTA CORREGIDA: Sube un nivel para encontrar la carpeta 'templates'
include_once '../templates/footer.php'; 
?>