<?php
require_once '../includes/seguridad.php'; 
$page_title = 'Monitor de Actividad';
include_once '../templates/header.php';

if (!puede('monitorear_sesiones')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once '../templates/footer.php';
    exit();
}
?>

<style>
.tabla-detalles { table-layout: fixed; width: 100%; }
.tabla-detalles td { word-break: break-all; }
.status-dot { height: 12px; width: 12px; border-radius: 50%; display: inline-block; margin-right: 8px; }
.status-dot.active { background-color: #28a745; box-shadow: 0 0 8px #28a745; }
.status-dot.inactive { background-color: #6c757d; }
.session-active-row { background-color: rgba(40, 167, 69, 0.15) !important; border-left: 4px solid #28a745; }
.ami-modal .ami-modal-body { max-height: 70vh; overflow-y: auto; }
.ami-modal .ami-modal-dialog.modal-lg { max-width: 90%; width: 1140px; }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="info-card">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5>Resumen de Usuarios</h5>
        <small class="text-white-50">Actualización automática cada 15 segundos</small>
    </div>
    <table class="ami-table">
        <thead><tr><th>Usuario</th><th>Rol</th><th>Estado</th><th>Última Actividad</th><th style="text-align: center;">Acciones</th></tr></thead>
        <tbody id="tablaUsuarios">
           <tr><td colspan="5" style="text-align: center;">Cargando...</td></tr>
        </tbody>
    </table>
</div>

<div class="ami-modal" id="modalSesiones">
    <div class="ami-modal-dialog modal-lg"> 
        <div class="ami-modal-content">
            <div class="ami-modal-header">
                <h5 class="ami-modal-title">Historial de Sesiones de <span id="nombreUsuarioSesiones" class="text-primary"></span></h5>
                <button type="button" class="ami-btn-close" onclick="ocultarModal('modalSesiones')">&times;</button>
            </div>
            <div class="ami-modal-body" id="modalBodySesiones"></div>
        </div>
    </div>
</div>

<div class="ami-modal" id="modalActividad">
    <div class="ami-modal-dialog modal-lg"> 
        <div class="ami-modal-content">
            <div class="ami-modal-header">
                <h5 class="ami-modal-title">Actividad Reciente de <span id="nombreUsuarioActividad" class="text-primary"></span></h5>
                <button type="button" class="ami-btn-close" onclick="ocultarModal('modalActividad')">&times;</button>
            </div>
            <div class="ami-modal-body" id="modalBodyActividad"></div>
        </div>
    </div>
</div>

<script>
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
const tablaUsuariosBody = document.getElementById('tablaUsuarios');

function mostrarModal(id) { document.getElementById(id).classList.add('show'); }
function ocultarModal(id) { document.getElementById(id).classList.remove('show'); }

function actualizarMonitor() {
    fetch('/api/sesiones_ajax.php?action=obtener_resumen_usuarios')
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                tablaUsuariosBody.innerHTML = ''; 
                if (data.data.length > 0) {
                    data.data.forEach(usuario => {
                        const estaActivo = parseInt(usuario.sesion_activa, 10) > 0;
                        const estadoHtml = estaActivo
                            ? `<span class="status-dot active"></span> Conectado`
                            : `<span class="status-dot inactive"></span> Desconectado`;
                        
                        const ultimaActividad = usuario.ultima_actividad_general 
                            ? new Date(usuario.ultima_actividad_general).toLocaleString('es-VE')
                            : 'Nunca';

                        tablaUsuariosBody.innerHTML += `
                            <tr data-user-id="${usuario.id}">
                                <td>${usuario.nombre}</td>
                                <td><span class="badge bg-secondary">${usuario.rol_nombre || 'N/A'}</span></td>
                                <td>${estadoHtml}</td>
                                <td>${ultimaActividad}</td>
                                <td style="text-align: center;">
                                    <button class="btn btn-sm btn-primary" onclick="gestionarSesiones(${usuario.id}, '${usuario.nombre.replace(/'/g, "\\'")}')"><i class="fa-solid fa-desktop"></i> Ver Sesiones</button>
                                    <button class="btn btn-sm btn-outline-light" onclick="verActividad(${usuario.id}, '${usuario.nombre.replace(/'/g, "\\'")}')"><i class="fa-solid fa-clipboard-list"></i> Ver Actividad</button>
                                </td>
                            </tr>`;
                    });
                } else {
                    tablaUsuariosBody.innerHTML = '<tr><td colspan="5" style="text-align: center;">No hay usuarios registrados.</td></tr>';
                }
            }
        });
}

function gestionarSesiones(usuarioId, nombreUsuario) {
    const modalBody = document.getElementById('modalBodySesiones');
    document.getElementById('nombreUsuarioSesiones').textContent = nombreUsuario;
    modalBody.innerHTML = '<p class="text-center">Cargando historial de sesiones...</p>';
    mostrarModal('modalSesiones');

    fetch(`/api/sesiones_ajax.php?action=obtener_detalles_usuario&usuario_id=${usuarioId}`)
    .then(res => res.json()).then(data => {
        if(data.success && data.data.sesiones.length > 0){
            let tablaHtml = '<div class="table-responsive"><table class="ami-table tabla-detalles"><thead><tr><th>Estado</th><th>Última Actividad</th><th>IP</th><th>Navegador</th><th class="text-center">Acción</th></tr></thead><tbody>';
            data.data.sesiones.forEach(s => {
                const esSesionActualPHP = s.session_id === '<?php echo session_id(); ?>';
                const esSesionActivaDB = s.is_active == 1;
                
                let estadoHtml, botonHtml;
                
                if (esSesionActivaDB && s.estado === 'activa') {
                    estadoHtml = '<span class="badge bg-success">ACTIVA</span>';
                    botonHtml = esSesionActualPHP 
                        ? '<span class="badge bg-info text-dark">Esta es tu sesión</span>' 
                        : `<button class="btn btn-sm btn-danger" onclick="cerrarSesion('${s.session_id}')">Forzar Cierre</button>`;
                } else {
                    estadoHtml = `<span class="badge bg-secondary">${s.estado}</span>`;
                    botonHtml = '---';
                }

                tablaHtml += `<tr class="${esSesionActivaDB ? 'session-active-row' : ''}">
                                <td>${estadoHtml}</td>
                                <td>${new Date(s.last_activity).toLocaleString('es-VE')}</td>
                                <td>${s.ip_address}</td>
                                <td>${s.user_agent}</td>
                                <td class="text-center">${botonHtml}</td>
                              </tr>`;
            });
            tablaHtml += '</tbody></table></div>';
            modalBody.innerHTML = tablaHtml;
        } else {
            modalBody.innerHTML = '<p class="text-center">No se encontraron registros de sesión para este usuario.</p>';
        }
    });
}

function verActividad(usuarioId, nombreUsuario) {
    // Esta función no necesita cambios, la dejamos como está.
    const modalBody = document.getElementById('modalBodyActividad');
    document.getElementById('nombreUsuarioActividad').textContent = nombreUsuario;
    modalBody.innerHTML = '<p class="text-center">Cargando actividad...</p>';
    mostrarModal('modalActividad');
    
    fetch(`/api/sesiones_ajax.php?action=obtener_detalles_usuario&usuario_id=${usuarioId}`)
    .then(res => res.json()).then(data => {
        if(data.success && data.data.bitacora.length > 0){
            let tablaHtml = '<div class="table-responsive"><table class="ami-table tabla-detalles"><thead><tr><th>Fecha</th><th>Acción</th><th>Detalle</th><th>IP</th></tr></thead><tbody>';
            data.data.bitacora.forEach(b => {
                tablaHtml += `<tr><td>${new Date(b.fecha).toLocaleString('es-VE')}</td><td>${b.accion}</td><td>${b.detalle}</td><td>${b.ip_address}</td></tr>`;
            });
            tablaHtml += '</tbody></table></div>';
            modalBody.innerHTML = tablaHtml;
        } else {
            modalBody.innerHTML = '<p class="text-center">No se encontró actividad reciente para este usuario.</p>';
        }
    });
}

function cerrarSesion(sessionId) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "Se cerrará la sesión de este usuario de forma remota. Será desconectado en su próxima acción.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sí, cerrar sesión',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#d33',
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData();
            formData.append('action', 'cerrar_sesion_remota');
            formData.append('session_id', sessionId);
            formData.append('csrf_token', csrfToken);
            
            fetch('/api/sesiones_ajax.php', { method: 'POST', body: formData })
            .then(res => res.json()).then(data => {
                if(data.success) {
                    Swal.fire('¡Hecho!', data.message, 'success');
                    ocultarModal('modalSesiones');
                    actualizarMonitor();
                } else {
                    Swal.fire('Error', data.message, 'error');
                }
            });
        }
    });
}

document.addEventListener('DOMContentLoaded', function() {
    actualizarMonitor();
    setInterval(actualizarMonitor, 15000);

    document.querySelectorAll('.ami-modal').forEach(modal => {
        modal.addEventListener('click', function(event) {
            if (event.target === modal) {
                ocultarModal(modal.id);
            }
        });
    });
});
</script>

<?php include_once '../templates/footer.php'; ?>