<?php
require_once 'includes/seguridad.php'; 
$page_title = 'Gestión de Almacén';
include_once 'templates/header.php';

if (!puede('ver_inventario')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>

<style>
/* Estilos específicos para el módulo de almacén */
.stat-card-almacen {
    background: var(--card-bg);
    padding: 1.5rem;
    border-radius: 12px;
    border-left: 5px solid var(--primary-color);
}
.stat-card-almacen .stat-value { font-size: 2rem; font-weight: 700; }
.stat-card-almacen .stat-label { font-size: 0.9rem; opacity: 0.8; }

.nav-tabs .nav-link {
    background-color: transparent;
    border-color: var(--border-color);
    color: var(--light-text);
}
.nav-tabs .nav-link.active {
    background-color: var(--primary-color);
    border-color: var(--primary-color);
    color: var(--dark-text);
    font-weight: bold;
}
.stock-bajo {
    background-color: rgba(255, 193, 7, 0.1) !important;
    border-left: 3px solid #ffc107;
}
.sin-stock {
    background-color: rgba(220, 53, 69, 0.1) !important;
    border-left: 3px solid #dc3545;
}
.ruta-stock-card {
    background: rgba(0,0,0,0.2);
    padding: 1rem;
    border-radius: 8px;
    margin-bottom: 1rem;
}
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <?php if (puede('gestionar_almacen')): ?>
        <button class="btn-add-new" onclick="abrirModalProducto('agregar')"><i class="fa-solid fa-plus"></i> Nuevo Producto</button>
    <?php endif; ?>
</div>

<div class="row mb-4">
    <div class="col-md-4"><div class="stat-card-almacen"><div class="stat-value" id="total-productos">...</div><div class="stat-label">Productos Diferentes</div></div></div>
    <div class="col-md-4"><div class="stat-card-almacen"><div class="stat-value" id="unidades-totales">...</div><div class="stat-label">Unidades Totales en Stock</div></div></div>
    <div class="col-md-4"><div class="stat-card-almacen"><div class="stat-value text-warning" id="productos-bajo-stock">...</div><div class="stat-label">Productos con Stock Bajo</div></div></div>
</div>

<div class="info-card">
    <div class="toolbar mb-3">
        <input type="text" id="searchInput" class="form-control form-control-dark" placeholder="Buscar...">
    </div>
    
    <ul class="nav nav-tabs" id="almacenTab" role="tablist">
        <li class="nav-item" role="presentation"><button class="nav-link active" id="inventario-tab" data-bs-toggle="tab" data-bs-target="#inventario" type="button" role="tab">Almacén Central</button></li>
        <li class="nav-item" role="presentation"><button class="nav-link" id="rutas-tab" data-bs-toggle="tab" data-bs-target="#rutas" type="button" role="tab">Stock en Rutas</button></li>
        <li class="nav-item" role="presentation"><button class="nav-link" id="movimientos-tab" data-bs-toggle="tab" data-bs-target="#movimientos" type="button" role="tab">Historial General</button></li>
    </ul>

    <div class="tab-content pt-3">
        <div class="tab-pane fade show active" id="inventario" role="tabpanel">
            <table class="ami-table">
                <thead><tr><th>SKU</th><th>Producto</th><th>Categoría</th><th>Stock Actual</th><th>Stock Mínimo</th><?php if(puede('gestionar_almacen')): ?><th>Acciones</th><?php endif; ?></tr></thead>
                <tbody id="tablaInventario"></tbody>
            </table>
        </div>
        <div class="tab-pane fade" id="rutas" role="tabpanel">
            <ul class="nav nav-pills mb-3">
                <li class="nav-item"><a class="nav-link active" data-bs-toggle="pill" href="#rutas-activas">Activas</a></li>
                <li class="nav-item"><a class="nav-link" data-bs-toggle="pill" href="#rutas-archivadas">Archivadas con Stock</a></li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane fade show active" id="rutas-activas">
                    <div id="rutas-stock-activas-container"></div>
                </div>
                <div class="tab-pane fade" id="rutas-archivadas">
                    <div id="rutas-stock-archivadas-container"></div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="movimientos" role="tabpanel">
            <table class="ami-table">
                <thead><tr><th>Fecha</th><th>Producto</th><th>Tipo</th><th>Cantidad</th><th>Motivo</th><th>Usuario</th></tr></thead>
                <tbody id="tablaMovimientos"></tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalProducto" tabindex="-1">
    <div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title" id="modalProductoTitle"></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body">
        <form id="formProducto"><input type="hidden" name="producto_id" id="producto_id"><div class="ami-form-group mb-3"><label>Nombre del Producto</label><input type="text" name="nombre" class="form-control" required></div><div class="ami-form-group mb-3"><label>SKU (Código Único)</label><input type="text" name="sku" class="form-control"></div><div class="ami-form-group mb-3"><label>Categoría</label><input type="text" name="categoria" class="form-control"></div><div class="ami-form-group mb-3"><label>Stock Mínimo de Alerta</label><input type="number" name="stock_minimo" class="form-control" min="0" value="0"></div><div class="ami-form-group"><label>Descripción</label><textarea name="descripcion" class="form-control" rows="3"></textarea></div></form>
    </div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarProducto">Guardar Producto</button></div></div></div>
</div>

<div class="modal fade ami-modal-theme" id="modalMovimiento" tabindex="-1">
    <div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Registrar Movimiento en Almacén Central</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body">
        <h4 id="movimiento-producto-nombre" class="mb-3 text-warning"></h4>
        <form id="formMovimiento"><input type="hidden" name="producto_id_mov" id="producto_id_mov"><div class="ami-form-group mb-3"><label>Tipo de Movimiento</label><select name="tipo_movimiento" class="form-select" required><option value="ingreso">Ingreso (+)</option><option value="egreso">Egreso (-)</option><option value="ajuste">Ajuste de Inventario</option></select></div><div class="ami-form-group mb-3"><label>Cantidad</label><input type="number" name="cantidad" class="form-control" min="1" required></div><div class="ami-form-group"><label>Motivo del Movimiento</label><input type="text" name="motivo" class="form-control" placeholder="Ej: Compra a proveedor, ajuste por pérdida" required></div></form>
    </div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnRegistrarMovimiento">Registrar</button></div></div></div>
</div>

<div class="modal fade ami-modal-theme" id="modalTransferirRuta" tabindex="-1">
    <div class="modal-dialog modal-lg"> <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Enviar Suministros a Ruta</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="form-agregar-producto-despacho" onsubmit="return false;">
                    <input type="hidden" name="ruta_id_trans" id="ruta_id_trans">
                    <div class="row align-items-end">
                        <div class="col-md-6">
                            <div class="ami-form-group">
                                <label>Producto</label>
                                <select id="producto-a-transferir" class="form-select" required></select>
                                <small id="stock-disponible-info" class="form-text text-white-50"></small>
                            </div>
                        </div>
                        <div class="col-md-3">
                             <div class="ami-form-group">
                                <label>Cantidad a Enviar</label>
                                <input type="number" id="cantidad-a-transferir" class="form-control" min="1" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <button type="button" class="btn btn-info w-100" id="btn-agregar-producto">
                                <i class="fa-solid fa-plus"></i> Añadir a la Lista
                            </button>
                        </div>
                    </div>
                </form>
                
                <hr class="my-4">

                <h5><i class="fa-solid fa-box-open"></i> Lista de Despacho</h5>
                <div class="table-responsive">
                    <table class="ami-table">
                        <thead>
                            <tr>
                                <th>Producto</th>
                                <th style="width: 120px;">Cantidad</th>
                                <th style="width: 80px;">Acción</th>
                            </tr>
                        </thead>
                        <tbody id="tabla-despacho-items">
                            </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnConfirmarTransferencia">
                    <i class="fa-solid fa-file-pdf"></i> Confirmar y Generar Despacho
                </button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade ami-modal-theme" id="modalReubicarStock" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Reubicar Stock de Ruta Archivada</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <form id="formReubicarStock">
                    <input type="hidden" name="ruta_origen_id" id="ruta_origen_id">
                    <p>Vas a transferir todo el stock sobrante de la ruta <strong id="nombre-ruta-origen" class="text-warning"></strong>.</p>
                    <div id="resumen-stock-reubicar" class="mb-3"></div>
                    <div class="ami-form-group mb-3">
                        <label class="ami-form-label">Transferir a la ruta activa:</label>
                        <select name="ruta_destino_id" id="select-ruta-destino" class="form-select" required></select>
                    </div>
                </form>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnConfirmarReubicacion">Confirmar Transferencia</button></div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const puedeGestionar = <?php echo json_encode(puede('gestionar_almacen')); ?>;
    const searchInput = document.getElementById('searchInput');

    // Modales
    const modalProducto = new bootstrap.Modal(document.getElementById('modalProducto'));
    const modalMovimiento = new bootstrap.Modal(document.getElementById('modalMovimiento'));
    const modalTransferir = new bootstrap.Modal(document.getElementById('modalTransferirRuta'));
    const modalReubicar = new bootstrap.Modal(document.getElementById('modalReubicarStock'));

    function cargarDashboard() {
        fetch('/api/almacen_ajax.php?action=cargar_dashboard')
        .then(res => res.json())
        .then(data => {
            if (!data.success) { Swal.fire('Error', data.message, 'error'); return; }
            const d = data.data;
            document.getElementById('total-productos').textContent = d.stats.total_productos || 0;
            document.getElementById('unidades-totales').textContent = d.stats.unidades_totales || 0;
            document.getElementById('productos-bajo-stock').textContent = d.stats.productos_bajo_stock || 0;
            renderizarTablaInventario(d.inventario);
            renderizarTablaMovimientos(d.movimientos);
            renderizarStockRutas('rutas-stock-activas-container', d.stock_rutas_activas || [], true);
            renderizarStockRutas('rutas-stock-archivadas-container', d.stock_rutas_archivadas || [], false);
        });
    }

    function renderizarTablaInventario(inventario) {
        const tbody = document.getElementById('tablaInventario');
        tbody.innerHTML = '';
        if (inventario.length === 0) {
            tbody.innerHTML = `<tr><td colspan="6" class="text-center">No hay productos registrados.</td></tr>`;
            return;
        }
        inventario.forEach(p => {
            const stock = p.cantidad || 0;
            let filaClass = '';
            if (stock <= 0) filaClass = 'sin-stock';
            else if (stock > 0 && stock <= p.stock_minimo) filaClass = 'stock-bajo';
            
            const accionesHTML = puedeGestionar ? `
                <td class="text-center">
                    <button class="btn btn-sm btn-success" title="Registrar Movimiento" onclick="abrirModalMovimiento(${p.id}, '${p.nombre.replace(/'/g, "\\'")}')"><i class="fa-solid fa-right-left"></i></button>
                    <button class="btn btn-sm btn-outline-light" title="Editar Producto" onclick="abrirModalProducto('editar', ${p.id})"><i class="fa-solid fa-pencil"></i></button>
                </td>` : '';

            tbody.innerHTML += `
                <tr class="${filaClass}">
                    <td>${p.sku || 'N/A'}</td>
                    <td><strong>${p.nombre}</strong></td>
                    <td>${p.categoria}</td>
                    <td class="fs-5 fw-bold">${stock}</td>
                    <td>${p.stock_minimo}</td>
                    ${accionesHTML}
                </tr>`;
        });
    }

    function renderizarTablaMovimientos(movimientos) {
        const tbody = document.getElementById('tablaMovimientos');
        tbody.innerHTML = '';
        if (movimientos.length === 0) {
            tbody.innerHTML = `<tr><td colspan="6" class="text-center">No hay movimientos recientes.</td></tr>`;
            return;
        }
        movimientos.forEach(m => {
            const tipoClase = m.tipo_movimiento === 'ingreso' ? 'text-success' : (m.tipo_movimiento === 'egreso' ? 'text-danger' : 'text-warning');
            const cantidadSigno = m.tipo_movimiento === 'ingreso' ? '+' : (m.tipo_movimiento === 'egreso' ? '-' : '');
            tbody.innerHTML += `
                <tr>
                    <td>${new Date(m.fecha_movimiento).toLocaleString()}</td>
                    <td>${m.producto_nombre}</td>
                    <td><strong class="${tipoClase}">${m.tipo_movimiento.charAt(0).toUpperCase() + m.tipo_movimiento.slice(1)}</strong></td>
                    <td class="${tipoClase} fw-bold">${cantidadSigno}${m.cantidad}</td>
                    <td>${m.motivo}</td>
                    <td>${m.usuario_nombre || 'Sistema'}</td>
                </tr>`;
        });
    }
    
    function renderizarStockRutas(containerId, rutas, esActiva) {
        const container = document.getElementById(containerId);
        container.innerHTML = '';
        if (rutas.length === 0) {
            container.innerHTML = `<p class="text-center text-white-50">No hay rutas en esta sección.</p>`;
            return;
        }

        rutas.forEach(ruta => {
            let productosHtml = '<tr><td colspan="3" class="text-center text-white-50 small">Esta ruta no tiene suministros.</td></tr>';
            if (ruta.productos && ruta.productos.length > 0) {
                productosHtml = ruta.productos.map(p => `<tr><td>${p.sku || 'N/A'}</td><td>${p.nombre}</td><td class="fs-5 fw-bold">${p.cantidad}</td></tr>`).join('');
            }
            
            let botonAccion = '';
            if (puedeGestionar) {
                if (esActiva) {
                    botonAccion = `<button class="btn btn-sm btn-success" onclick="abrirModalTransferencia(${ruta.id})"><i class="fa-solid fa-truck-fast"></i> Enviar Suministros</button>`;
                } else {
                    botonAccion = `<button class="btn btn-sm btn-warning" onclick="abrirModalReubicacion(${ruta.id}, '${ruta.nombre_ruta.replace(/'/g, "\\'")}')"><i class="fa-solid fa-right-left"></i> Reubicar Stock</button>`;
                }
            }

            container.innerHTML += `
                <div class="ruta-stock-card">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5>${ruta.nombre_ruta}</h5>
                        ${botonAccion}
                    </div>
                    <hr style="border-color: var(--border-color);">
                    <table class="ami-table">
                        <thead><tr><th>SKU</th><th>Producto</th><th>Stock en Ruta</th></tr></thead>
                        <tbody>${productosHtml}</tbody>
                    </table>
                </div>`;
        });
    }

    window.abrirModalProducto = function(modo, id = null) {
        const form = document.getElementById('formProducto');
        form.reset();
        document.getElementById('modalProductoTitle').textContent = modo === 'agregar' ? 'Registrar Nuevo Producto' : 'Editar Producto';
        if (modo === 'editar') {
            fetch(`/api/almacen_ajax.php?action=obtener_producto&id=${id}`)
            .then(res => res.json()).then(data => {
                if(data.success){
                    const p = data.data;
                    document.getElementById('producto_id').value = p.id;
                    form.querySelector('[name="nombre"]').value = p.nombre;
                    form.querySelector('[name="sku"]').value = p.sku;
                    form.querySelector('[name="categoria"]').value = p.categoria;
                    form.querySelector('[name="stock_minimo"]').value = p.stock_minimo;
                    form.querySelector('[name="descripcion"]').value = p.descripcion;
                } else { Swal.fire('Error', data.message, 'error'); }
            });
        }
        modalProducto.show();
    }

    window.abrirModalMovimiento = function(id, nombre) {
        document.getElementById('formMovimiento').reset();
        document.getElementById('producto_id_mov').value = id;
        const nombreProductoElement = document.getElementById('movimiento-producto-nombre');
        if (nombreProductoElement) {
            nombreProductoElement.textContent = nombre;
        }
        modalMovimiento.show();
    }
    
    window.abrirModalReubicacion = function(rutaId, nombreRuta) {
        const form = document.getElementById('formReubicarStock');
        form.reset();
        document.getElementById('ruta_origen_id').value = rutaId;
        document.getElementById('nombre-ruta-origen').textContent = nombreRuta;
        const selectDestino = document.getElementById('select-ruta-destino');
        selectDestino.innerHTML = '<option value="">Cargando rutas...</option>';

        fetch('/api/almacen_ajax.php?action=get_rutas_activas')
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                selectDestino.innerHTML = '<option value="">-- Seleccione una ruta de destino --</option>';
                data.data.forEach(ruta => {
                    if (ruta.id !== rutaId) {
                        selectDestino.innerHTML += `<option value="${ruta.id}">${ruta.nombre_ruta}</option>`;
                    }
                });
            } else {
                selectDestino.innerHTML = '<option value="">Error al cargar rutas</option>';
            }
        });
        
        const rutaData = Array.from(document.querySelectorAll('#rutas-stock-archivadas-container .ruta-stock-card')).find(card => card.querySelector(`button[onclick*="'${rutaId}'"]`));
        if(rutaData){
            document.getElementById('resumen-stock-reubicar').innerHTML = rutaData.querySelector('table').outerHTML;
        }
        modalReubicar.show();
    }

    document.getElementById('btnGuardarProducto').addEventListener('click', function() {
        const form = document.getElementById('formProducto');
        const formData = new FormData(form);
        formData.append('action', 'guardar_producto');
        formData.append('csrf_token', csrfToken);
        fetch('/api/almacen_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                modalProducto.hide();
                Swal.fire('¡Éxito!', data.message, 'success');
                cargarDashboard();
            } else { Swal.fire('Error', data.message, 'error'); }
        });
    });

    document.getElementById('btnRegistrarMovimiento').addEventListener('click', function() {
        const form = document.getElementById('formMovimiento');
        const formData = new FormData(form);
        formData.append('action', 'registrar_movimiento');
        formData.append('csrf_token', csrfToken);
        fetch('/api/almacen_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                modalMovimiento.hide();
                Swal.fire('¡Éxito!', 'Movimiento registrado correctamente.', 'success');
                cargarDashboard();
            } else { Swal.fire('Error', data.message, 'error'); }
        });
    });
    
    document.getElementById('btnConfirmarReubicacion').addEventListener('click', function(){
        const form = document.getElementById('formReubicarStock');
        const formData = new FormData(form);
        formData.append('action', 'reubicar_stock_ruta');
        formData.append('csrf_token', csrfToken);
        if(!formData.get('ruta_destino_id')){
            Swal.fire('Atención', 'Debe seleccionar una ruta de destino.', 'warning');
            return;
        }
        fetch('/api/almacen_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if(data.success){
                modalReubicar.hide();
                Swal.fire('¡Éxito!', data.message, 'success');
                cargarDashboard();
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        });
    });

    // ========= NUEVA LÓGICA PARA EL MODAL DE TRANSFERENCIA =========
    
    window.abrirModalTransferencia = function(rutaId) {
        document.getElementById('form-agregar-producto-despacho').reset();
        document.getElementById('ruta_id_trans').value = rutaId;
        document.getElementById('tabla-despacho-items').innerHTML = ''; // Limpiar la lista
        document.getElementById('stock-disponible-info').textContent = '';
        const selectProducto = document.getElementById('producto-a-transferir');
        selectProducto.innerHTML = '<option value="">Cargando productos...</option>';
        
        fetch('/api/almacen_ajax.php?action=get_productos_para_transferencia')
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                selectProducto.innerHTML = '<option value="">-- Seleccione un producto --</option>';
                data.data.forEach(p => {
                    selectProducto.innerHTML += `<option value="${p.id}" data-stock="${p.cantidad}" data-nombre="${p.nombre}">${p.nombre} (Stock: ${p.cantidad})</option>`;
                });
            } else {
                selectProducto.innerHTML = '<option value="">Error al cargar</option>';
            }
        });
        modalTransferir.show();
    }

    document.getElementById('producto-a-transferir').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const stock = selectedOption.dataset.stock;
        const cantidadInput = document.getElementById('cantidad-a-transferir');
        const stockInfo = document.getElementById('stock-disponible-info');
        if (stock) {
            cantidadInput.max = stock;
            stockInfo.textContent = `Máximo a enviar: ${stock}`;
        } else {
            cantidadInput.max = null;
            stockInfo.textContent = '';
        }
    });

    document.getElementById('btn-agregar-producto').addEventListener('click', function() {
        const selectProducto = document.getElementById('producto-a-transferir');
        const cantidadInput = document.getElementById('cantidad-a-transferir');
        const productoId = selectProducto.value;
        const cantidad = parseInt(cantidadInput.value);
        
        if (!productoId || !cantidad || cantidad <= 0) {
            Swal.fire('Atención', 'Seleccione un producto y una cantidad válida.', 'warning');
            return;
        }

        const selectedOption = selectProducto.options[selectProducto.selectedIndex];
        const stock = parseInt(selectedOption.dataset.stock);
        const nombre = selectedOption.dataset.nombre;

        if (cantidad > stock) {
            Swal.fire('Error', `Stock insuficiente. Solo hay ${stock} unidades disponibles.`, 'error');
            return;
        }
        
        const existingRow = document.querySelector(`#tabla-despacho-items tr[data-producto-id='${productoId}']`);
        if (existingRow) {
            Swal.fire('Atención', 'Ese producto ya está en la lista. Puede eliminarlo y volver a agregarlo con la nueva cantidad.', 'warning');
            return;
        }

        const tbody = document.getElementById('tabla-despacho-items');
        const newRow = `
            <tr data-producto-id="${productoId}">
                <td>${nombre}</td>
                <td><input type="number" class="form-control form-control-sm cantidad-item" value="${cantidad}" min="1" max="${stock}" readonly></td>
                <td><button class="btn btn-sm btn-danger btn-remover-item"><i class="fa-solid fa-trash"></i></button></td>
            </tr>
        `;
        tbody.insertAdjacentHTML('beforeend', newRow);

        selectProducto.value = '';
        cantidadInput.value = '';
        document.getElementById('stock-disponible-info').textContent = '';
    });

    document.getElementById('tabla-despacho-items').addEventListener('click', function(e) {
        if (e.target.closest('.btn-remover-item')) {
            e.target.closest('tr').remove();
        }
    });

    document.getElementById('btnConfirmarTransferencia').addEventListener('click', function() {
        const rutaId = document.getElementById('ruta_id_trans').value;
        const rows = document.querySelectorAll('#tabla-despacho-items tr');
        
        if (rows.length === 0) {
            Swal.fire('Error', 'La lista de despacho está vacía.', 'error');
            return;
        }

        const productos = [];
        rows.forEach(row => {
            productos.push({
                producto_id: row.dataset.productoId,
                cantidad: row.querySelector('.cantidad-item').value
            });
        });

        const formData = new FormData();
        formData.append('action', 'transferir_stock_a_ruta');
        formData.append('csrf_token', csrfToken);
        formData.append('ruta_id_trans', rutaId);
        formData.append('productos', JSON.stringify(productos));

        this.disabled = true;
        this.innerHTML = '<span class="spinner-border spinner-border-sm"></span> Procesando...';

        fetch('/api/almacen_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                modalTransferir.hide();
                Swal.fire({
                    title: '¡Éxito!',
                    text: data.message,
                    icon: 'success',
                    confirmButtonText: 'Descargar PDF y Cerrar'
                }).then(() => {
                    // LLAMADA AL NUEVO ARCHIVO PARA EL PDF
                    window.open(`/api/pdf_almacen_ajax.php?id=${data.despacho_id}`, '_blank');
                    cargarDashboard();
                });
            } else { 
                Swal.fire('Error', data.message, 'error'); 
            }
        }).finally(() => {
            const btn = document.getElementById('btnConfirmarTransferencia');
            btn.disabled = false;
            btn.innerHTML = '<i class="fa-solid fa-file-pdf"></i> Confirmar y Generar Despacho';
        });
    });

    // ===================================================================

    searchInput.addEventListener('keyup', function() {
        const filter = searchInput.value.toLowerCase();
        const activeTab = document.querySelector('.tab-pane.active');
        if (!activeTab.querySelector('tbody')) return;
        
        const tableBody = activeTab.querySelector('tbody');
        const rows = tableBody.getElementsByTagName('tr');
        for (let i = 0; i < rows.length; i++) {
            const row = rows[i];
            const cells = row.getElementsByTagName('td');
            let found = false;
            for (let j = 0; j < cells.length; j++) {
                if (cells[j]) {
                    if (cells[j].textContent.toLowerCase().indexOf(filter) > -1) {
                        found = true;
                        break;
                    }
                }
            }
            row.style.display = found ? "" : "none";
        }
    });

    cargarDashboard();
});
</script>

<?php include_once 'templates/footer.php'; ?>