<?php
// --- CORRECCIÓN --- Se ajusta la ruta para subir un nivel (de 'ajustes/' a 'administracion/')
require_once '../includes/seguridad.php'; 

// Permiso para gestionar la clave maestra
if (!puede('gestionar_clave_maestra')) {
    // --- CORRECCIÓN --- Se ajusta la ruta para el redireccionamiento
    header('Location: ../inicio.php?error=acceso_denegado');
    exit();
}


$page_title = 'Cambiar Clave Maestra de Administradr';
// --- CORRECCIÓN --- Se ajusta la ruta para subir un nivel
include_once '../templates/header.php';
?>

<style>
    .strength-meter {
        height: 5px;
        background-color: #333;
        border-radius: 5px;
        margin-top: 5px;
    }
    .strength-meter div {
        height: 100%;
        width: 0%;
        border-radius: 5px;
        transition: width 0.3s ease, background-color 0.3s ease;
    }
    .strength-meter .very-weak { background-color: #dc3545; }
    .strength-meter .weak { background-color: #fd7e14; }
    .strength-meter .medium { background-color: #ffc107; }
    .strength-meter .strong { background-color: #198754; }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="info-card" style="max-width: 600px; margin: auto;">

    <!-- PASO 1: Re-autenticación -->
    <div id="reauth-container">
        <h5 class="text-warning">Paso 1: Verificación de Seguridad</h5>
        <p class="text-white-50">Para continuar, por favor ingrese su contraseña de inicio de sesión actual.</p>
        <hr>
        <form id="form-reauth">
            <div class="ami-form-group mb-3">
                <label for="password_actual_usuario" class="ami-form-label">Su Contraseña Actual</label>
                <input type="password" id="password_actual_usuario" class="form-control form-control-dark" required>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn btn-warning">
                    <i class="fa-solid fa-lock-open me-2"></i>Desbloquear
                </button>
            </div>
        </form>
    </div>

    <!-- PASO 2: Formulario de Cambio de Clave (Oculto por defecto) -->
    <div id="change-key-container" class="d-none">
        <h5 class="text-success">Paso 2: Cambiar Clave Maestra</h5>
        <p class="text-white-50">La sesión segura ha sido verificada. Ahora puede proceder a cambiar la clave maestra.</p>
        <hr>
        <form id="form-cambiar-clave">
            <div class="ami-form-group mb-3">
                <label for="clave_actual" class="ami-form-label">Clave Maestra Actual</label>
                <input type="password" id="clave_actual" name="clave_actual" class="form-control form-control-dark" required>
            </div>
            <div class="ami-form-group mb-3">
                <label for="nueva_clave" class="ami-form-label">Nueva Clave Maestra</label>
                <input type="password" id="nueva_clave" name="nueva_clave" class="form-control form-control-dark" required>
                <div class="strength-meter"><div id="strength-bar"></div></div>
                <small id="strength-text" class="form-text text-white-50"></small>
            </div>
            <div class="ami-form-group mb-4">
                <label for="confirmar_nueva_clave" class="ami-form-label">Confirmar Nueva Clave Maestra</label>
                <input type="password" id="confirmar_nueva_clave" name="confirmar_nueva_clave" class="form-control form-control-dark" required>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fa-solid fa-key me-2"></i>Actualizar Clave Maestra
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const reauthContainer = document.getElementById('reauth-container');
    const changeKeyContainer = document.getElementById('change-key-container');
    const formReauth = document.getElementById('form-reauth');
    const formChangeKey = document.getElementById('form-cambiar-clave');

    // FORMULARIO DE RE-AUTENTICACIÓN
    formReauth.addEventListener('submit', function(e) {
        e.preventDefault();
        const password = document.getElementById('password_actual_usuario').value;
        const submitButton = this.querySelector('button[type="submit"]');
        submitButton.disabled = true;
        submitButton.innerHTML = '<i class="fa-solid fa-spinner fa-spin me-2"></i>Verificando...';

        const formData = new FormData();
        formData.append('action', 'reautenticar_para_clave_maestra');
        formData.append('csrf_token', csrfToken);
        formData.append('password_actual_usuario', password);

        fetch('/api/ajustes_ajax.php', { method: 'POST', body: formData })
        .then(res => {
            if (!res.ok) {
                throw new Error(`HTTP error! status: ${res.status}`);
            }
            return res.json();
        })
        .then(data => {
            if (data.success) {
                Swal.fire({ toast: true, position: 'top-end', icon: 'success', title: 'Acceso Desbloqueado', showConfirmButton: false, timer: 2000 });
                reauthContainer.classList.add('d-none');
                changeKeyContainer.classList.remove('d-none');
            } else {
                Swal.fire({ icon: 'error', title: 'Error de Autenticación', text: data.message });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({ icon: 'error', title: 'Error de Conexión', text: 'No se pudo conectar con el servidor' });
        })
        .finally(() => {
            submitButton.disabled = false;
            submitButton.innerHTML = '<i class="fa-solid fa-lock-open me-2"></i>Desbloquear';
        });
    });

    // FORMULARIO DE CAMBIO DE CLAVE
    formChangeKey.addEventListener('submit', function(e) {
        e.preventDefault();
        const submitButton = this.querySelector('button[type="submit"]');
        submitButton.disabled = true;
        submitButton.innerHTML = '<i class="fa-solid fa-spinner fa-spin me-2"></i>Actualizando...';

        const formData = new FormData(formChangeKey);
        formData.append('action', 'cambiar_clave_maestra');
        formData.append('csrf_token', csrfToken);

        // *** CORRECCIÓN PRINCIPAL: Cambiar la ruta del fetch ***
        fetch('/api/ajustes_ajax.php', { method: 'POST', body: formData })
        .then(res => {
            if (!res.ok) {
                throw new Error(`HTTP error! status: ${res.status}`);
            }
            return res.json();
        })
        .then(data => {
            if (data.success) {
                Swal.fire('¡Éxito!', data.message, 'success');
                formChangeKey.reset();
                // Bloquear de nuevo
                reauthContainer.classList.remove('d-none');
                changeKeyContainer.classList.add('d-none');
                document.getElementById('password_actual_usuario').value = '';
            } else {
                Swal.fire('Error', data.message, 'error');
                if (data.requiere_reauth) {
                    reauthContainer.classList.remove('d-none');
                    changeKeyContainer.classList.add('d-none');
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({ icon: 'error', title: 'Error de Conexión', text: 'No se pudo conectar con el servidor' });
        })
        .finally(() => {
            submitButton.disabled = false;
            submitButton.innerHTML = '<i class="fa-solid fa-key me-2"></i>Actualizar Clave Maestra';
        });
    });

    // MEDIDOR DE FORTALEZA DE CONTRASEÑA
    const nuevaClaveInput = document.getElementById('nueva_clave');
    const strengthBar = document.getElementById('strength-bar');
    const strengthText = document.getElementById('strength-text');

    nuevaClaveInput.addEventListener('input', function() {
        const val = this.value;
        let score = 0;
        if (val.length >= 8) score++;
        if (val.match(/[a-z]/)) score++;
        if (val.match(/[A-Z]/)) score++;
        if (val.match(/[0-9]/)) score++;
        if (val.match(/[^a-zA-Z0-9]/)) score++;

        strengthBar.className = '';
        switch (score) {
            case 1: 
                strengthBar.style.width = '20%'; 
                strengthBar.classList.add('very-weak'); 
                strengthText.textContent = 'Muy Débil'; 
                break;
            case 2: 
                strengthBar.style.width = '40%'; 
                strengthBar.classList.add('weak'); 
                strengthText.textContent = 'Débil'; 
                break;
            case 3: 
                strengthBar.style.width = '60%'; 
                strengthBar.classList.add('medium'); 
                strengthText.textContent = 'Mediana'; 
                break;
            case 4: 
                strengthBar.style.width = '80%'; 
                strengthBar.classList.add('strong'); 
                strengthText.textContent = 'Fuerte'; 
                break;
            case 5: 
                strengthBar.style.width = '100%'; 
                strengthBar.classList.add('strong'); 
                strengthText.textContent = 'Muy Fuerte'; 
                break;
            default: 
                strengthBar.style.width = '0%'; 
                strengthText.textContent = ''; 
                break;
        }
    });
});
</script>


<?php 
// --- CORRECCIÓN --- Se ajusta la ruta para subir un nivel
include_once '../templates/footer.php'; 
?>