<?php
require_once 'includes/seguridad.php'; 
$page_title = 'Gestión de Clientes';
include_once 'templates/header.php';

if (!puede('gestionar_clientes')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="info-card">
    <div class="toolbar mb-3 d-flex justify-content-between">
        <input type="text" id="searchInput" class="form-control form-control-dark" style="max-width: 400px;" placeholder="Buscar por nombre, cédula o ciudad...">
        <button class="btn-add-new" onclick="abrirModalCliente('agregar')"><i class="fa-solid fa-plus"></i> Registrar Cliente</button>
    </div>
    <table class="ami-table">
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Cédula</th>
                <th>Teléfono</th>
                <th>Ciudad</th>
                <th>Fecha de Ingreso</th>
                <th style="text-align: center;">Acciones</th>
            </tr>
        </thead>
        <tbody id="clientesTableBody"></tbody>
    </table>
</div>

<div class="ami-modal" id="modalCliente">
  <div class="ami-modal-dialog modal-lg">
    <div class="ami-modal-content">
      <div class="ami-modal-header"><h5 class="ami-modal-title" id="modalClienteTitle"></h5><button type="button" class="ami-btn-close" onclick="ocultarModal('modalCliente')">&times;</button></div>
      <div class="ami-modal-body" style="max-height: 80vh; overflow-y: auto;">
        <form id="formCliente">
          <input type="hidden" name="id" id="cliente_id">
          <div class="row">
            <div class="col-md-6 ami-form-group mb-3"><label>Nombre Completo</label><input type="text" name="nombre" class="ami-form-control" required></div>
            <div class="col-md-6 ami-form-group mb-3"><label>Cédula</label><input type="text" name="cedula" class="ami-form-control" required></div>
            <div class="col-md-6 ami-form-group mb-3"><label>Teléfono</label><input type="text" name="telefono" class="ami-form-control"></div>
            <div class="col-md-6 ami-form-group mb-3"><label>Email</label><input type="email" name="email" class="ami-form-control"></div>
            <div class="col-md-6 ami-form-group mb-3"><label>Edad</label><input type="number" name="edad" class="ami-form-control"></div>
            <div class="col-md-6 ami-form-group mb-3"><label>País</label><input type="text" name="pais" class="ami-form-control"></div>
            <div class="col-md-12 ami-form-group mb-3"><label>Ciudad</label><input type="text" name="ciudad" class="ami-form-control"></div>
            <div class="col-md-12 ami-form-group mb-3"><label>Dirección</label><textarea name="direccion" class="ami-form-control" rows="2"></textarea></div>
            <div class="col-md-12 ami-form-group mb-3"><label>Historial / Notas Relevantes</label><textarea name="historial_medico_resumen" class="ami-form-control" rows="3"></textarea></div>
          </div>
          <hr style="border-color: var(--border-color); margin: 1.5rem 0;">
          <button type="submit" class="ami-btn ami-btn-primary" id="modalClienteSubmit">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
let todosLosClientes = [];

function cargarClientes() {
    fetch('/api/clientes_ajax.php?action=cargar_clientes')
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                todosLosClientes = data.data;
                renderizarTabla();
            } else { Swal.fire('Error', data.message, 'error'); }
        });
}

function renderizarTabla() {
    const tablaBody = document.getElementById('clientesTableBody');
    const filtro = document.getElementById('searchInput').value.toLowerCase();
    tablaBody.innerHTML = '';
    
    const clientesFiltrados = todosLosClientes.filter(c => 
        (c.nombre || '').toLowerCase().includes(filtro) ||
        (c.cedula || '').toLowerCase().includes(filtro) ||
        (c.ciudad || '').toLowerCase().includes(filtro)
    );

    if (clientesFiltrados.length === 0) {
        tablaBody.innerHTML = '<tr><td colspan="6" class="text-center">No se encontraron clientes.</td></tr>';
        return;
    }

    clientesFiltrados.forEach(c => {
        const fechaIngreso = new Date(c.fecha_creacion).toLocaleDateString('es-ES');
        tablaBody.innerHTML += `
            <tr>
                <td>${c.nombre}</td>
                <td>${c.cedula}</td>
                <td>${c.telefono || 'N/A'}</td>
                <td>${c.ciudad || 'N/A'}</td>
                <td>${fechaIngreso}</td>
                <td class="text-center">
                    <button class="btn-action" onclick="abrirModalCliente('editar', ${c.id})"><i class="fa-solid fa-pencil"></i></button>
                </td>
            </tr>`;
    });
}

function abrirModalCliente(modo, id = null) {
    const form = document.getElementById('formCliente');
    form.reset();
    form.setAttribute('data-action', modo === 'agregar' ? 'agregar_cliente' : 'editar_cliente');
    document.getElementById('modalClienteTitle').textContent = modo === 'agregar' ? 'Registrar Nuevo Cliente' : 'Editar Ficha de Cliente';
    
    if (modo === 'editar') {
        fetch(`/api/clientes_ajax.php?action=obtener_cliente&id=${id}`)
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    for (const key in data.data) {
                        const field = form.querySelector(`[name="${key}"]`);
                        if (field) field.value = data.data[key] || '';
                    }
                } else { Swal.fire('Error', data.message, 'error'); }
            });
    }
    
    document.getElementById('modalCliente').classList.add('show');
}


document.getElementById('formCliente').addEventListener('submit', function(e) {
    e.preventDefault();
    const action = this.getAttribute('data-action');
    const formData = new FormData(this);
    formData.append('action', action);
    formData.append('csrf_token', csrfToken);

    fetch('/api/clientes_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                ocultarModal('modalCliente');
                Swal.fire('¡Éxito!', data.message, 'success').then(cargarClientes);
            } else { Swal.fire('Error', data.message, 'error'); }
        });
});

function ocultarModal(id) { document.getElementById(id).classList.remove('show'); }

document.addEventListener('DOMContentLoaded', cargarClientes);
document.getElementById('searchInput').addEventListener('input', renderizarTabla);
</script>

<?php include_once 'templates/footer.php'; ?>