<?php
require_once 'includes/seguridad.php';
if (!puede('ver_nomina') && !puede('gestionar_nomina')) { header('Location: inicio.php?error=acceso_denegado'); exit(); }
$page_title = 'Gestión de Nóminas';
include_once 'templates/header.php';
?>

<style>
    /* Estilos para los estados de la nómina */
    .estado-generada { color: #0dcaf0; font-weight: bold; }
    .estado-pagada { color: #198754; font-weight: bold; }
    .estado-borrador { color: #6c757d; font-weight: bold; }
</style>

<div class="main-header">
    <h1><?php echo htmlspecialchars($page_title); ?></h1>
    <?php if (puede('gestionar_nomina')): ?>
        <a href="nomina-crear.php" class="btn-add-new">
            <i class="fa-solid fa-plus"></i> Nueva Nómina
        </a>
    <?php endif; ?>
</div>

<div class="info-card">
    <div class="toolbar mb-3">
        <p class="text-muted">Listado de todas las nóminas generadas en el sistema.</p>
    </div>
    <div class="table-responsive">
        <table class="ami-table" id="tabla-nominas">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombre / Descripción</th>
                    <th>Periodo de Pago</th>
                    <th>Fecha de Creación</th>
                    <th>Generado Por</th>
                    <th class="text-center">Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                </tbody>
        </table>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    const tablaBody = document.querySelector("#tabla-nominas tbody");

    const renderizarTabla = (nominas) => {
        tablaBody.innerHTML = '';
        if (!nominas || nominas.length === 0) {
            tablaBody.innerHTML = `<tr><td colspan="7" class="text-center">No se han encontrado nóminas.</td></tr>`;
            return;
        }

        const statusMap = {
            'Generada': 'estado-generada',
            'Pagada': 'estado-pagada',
            'Borrador': 'estado-borrador'
        };

        nominas.forEach(nomina => {
            const periodo = `${new Date(nomina.fecha_inicio + 'T00:00:00').toLocaleDateString('es-VE')} al ${new Date(nomina.fecha_fin + 'T00:00:00').toLocaleDateString('es-VE')}`;
            const fechaCreacion = new Date(nomina.fecha_creacion).toLocaleString('es-VE', { dateStyle: 'short', timeStyle: 'short' });
            const statusClass = statusMap[nomina.estado] || '';
            
            // Botones de acción. Más adelante agregaremos la funcionalidad para anular o pagar.
            const accionesHtml = `
                <div class="d-flex gap-2">
                    <button class="btn btn-sm btn-info" onclick="verDetalleNomina(${nomina.id})" title="Ver Detalle">
                        <i class="fa-solid fa-eye"></i>
                    </button>
                </div>
            `;
            
            const fila = `
                <tr>
                    <td>${nomina.id}</td>
                    <td><strong>${nomina.nombre_nomina}</strong></td>
                    <td>${periodo}</td>
                    <td>${fechaCreacion}</td>
                    <td>${nomina.creado_por}</td>
                    <td class="text-center"><span class="${statusClass}">${nomina.estado}</span></td>
                    <td>${accionesHtml}</td>
                </tr>
            `;
            tablaBody.innerHTML += fila;
        });
    };

    const cargarNominas = () => {
        tablaBody.innerHTML = `<tr><td colspan="7" class="text-center">Cargando nóminas...</td></tr>`;
        fetch('../api/nominas_ajax.php?action=listar_nominas')
            .then(res => res.json())
            .then(response => {
                if (response.success) {
                    renderizarTabla(response.data);
                } else {
                    tablaBody.innerHTML = `<tr><td colspan="7" class="text-center text-danger">${response.message}</td></tr>`;
                }
            })
            .catch(err => {
                 tablaBody.innerHTML = `<tr><td colspan="7" class="text-center text-danger">Error de conexión al cargar las nóminas.</td></tr>`;
            });
    };

    // Hacemos la función global para poder llamarla desde el HTML
    window.verDetalleNomina = function(id) {
        window.location.href = `nomina-detalle.php?id=${id}`;
    };

    // Carga inicial
    cargarNominas();
});
</script>

<?php include_once 'templates/footer.php'; ?>