<?php
require_once 'includes/seguridad.php';
$page_title = 'Mis Prospectos';
include_once 'templates/header.php';

if (!puede('ver_prospectos_operador')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
.main-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem; margin-bottom: 1.5rem; }
.header-actions { display: flex; align-items: center; gap: 1rem; flex-wrap: wrap; }
.stat-card-mini { background: var(--card-bg); padding: 0.5rem 1rem; border-radius: 12px; text-align: center; border: 1px solid var(--border-color); }
.stat-card-mini .stat-value { font-size: 1.8rem; font-weight: 700; color: var(--primary-color); }
.stat-card-mini .stat-label { font-size: 0.75rem; opacity: 0.8; text-transform: uppercase; margin-top: -5px; display: block; }
.toolbar { display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 1rem; align-items: end; margin-bottom: 2rem; }
.toolbar > div { display: flex; flex-direction: column; }
.badge-estado { padding: 0.4em 0.7em; border-radius: 10px; font-weight: 500; text-transform: capitalize; color: white; }
.telefono-clickable { cursor: pointer; text-decoration: underline; text-decoration-color: var(--primary-color); text-decoration-thickness: 1px; transition: color 0.2s ease; }
.telefono-clickable:hover { color: var(--primary-color); }
.ami-table tbody tr { cursor: pointer; transition: background-color 0.2s ease; }
.ami-table tbody tr:hover { background-color: rgba(120, 227, 32, 0.1); }
.pagination-container { display: flex; justify-content: center; align-items: center; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid var(--border-color); user-select: none; }
.pagination-btn { background: rgba(255,255,255,0.05); border: 1px solid var(--border-color); color: var(--light-text); padding: 8px 14px; margin: 0 4px; border-radius: 8px; cursor: pointer; transition: all 0.2s ease; font-size: 0.9em; }
.pagination-btn:hover { background-color: var(--primary-color); color: var(--dark-text); border-color: var(--primary-color); transform: translateY(-2px); }
.pagination-btn.active { background-color: var(--primary-color); color: var(--dark-text); border-color: var(--primary-color); font-weight: bold; }
.pagination-btn.disabled { opacity: 0.4; cursor: not-allowed; background-color: rgba(0,0,0,0.2); }
.pagination-info { margin: 0 1rem; font-size: 0.9em; opacity: 0.8; }
input.flatpickr-input { background-color: rgba(15, 23, 42, 0.7) !important; color: var(--light-text) !important; border: 1px solid #475569 !important; }

/* Sistema de Z-index para modales */
.modal-generic { z-index: 9500 !important; }
.modal-management { z-index: 10000 !important; }
.modal-alerts { z-index: 10500 !important; }
.modal-notifications { z-index: 11000 !important; }

/* Backdrop personalizado para modal de alertas */
.modal-alerts-backdrop {
    background-color: rgba(0, 0, 0, 0.7) !important;
    backdrop-filter: blur(3px) !important;
    -webkit-backdrop-filter: blur(3px) !important;
}

/* Backdrop personalizado para modal de notificaciones */
.modal-notifications-backdrop {
    background-color: rgba(0, 0, 0, 0.6) !important;
    backdrop-filter: blur(2px) !important;
    -webkit-backdrop-filter: blur(2px) !important;
}

/* Efecto de enfoque para modales importantes */
.modal-alerts .modal-content {
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5) !important;
    border: 2px solid rgba(255, 193, 7, 0.3) !important;
}

.modal-notifications .modal-content {
    box-shadow: 0 15px 50px rgba(0, 0, 0, 0.4) !important;
}

.ami-table th.col-notas, .ami-table td.col-notas { text-align: center; width: 60px; }
.ami-table td.col-notas i { cursor: help; font-size: 1.1rem; color: #adb5bd; transition: color 0.2s ease; }
.ami-table td.col-notas i:hover { color: var(--primary-color); }
#historialNotas { max-height: 150px; overflow-y: auto; background: rgba(0,0,0,0.2); padding: 10px; border-radius: 5px; margin-bottom: 1rem; white-space: pre-wrap; font-size: 0.85em; border: 1px solid var(--border-color); }

#agendamiento-container { background-color: rgba(120, 227, 32, 0.08); padding: 1rem; border-radius: 8px; margin-top: 1.5rem; border: 1px solid var(--border-color); }

/* Nuevo estilo para el contenedor de nombre */
#nombre-sin-nombre-container {
    background-color: rgba(255, 193, 7, 0.1);
    padding: 1rem;
    border-radius: 8px;
    margin-bottom: 1.5rem;
    border: 1px solid rgba(255, 193, 7, 0.3);
}

#nombre-sin-nombre-container .alert-warning {
    background-color: rgba(255, 193, 7, 0.2);
    border-color: rgba(255, 193, 7, 0.5);
    color: #856404;
    margin-bottom: 1rem;
    padding: 0.75rem;
    border-radius: 6px;
}

#alerta-prospectos-lista li { display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.75rem; border-bottom: 1px solid var(--border-color); padding-bottom: 0.75rem; }
#alerta-prospectos-lista li:last-child { border-bottom: none; margin-bottom: 0; }
.btn-whatsapp { background-color: #25D366; color: white; border: none; padding: 5px 10px; border-radius: 5px; font-size: 0.85em; margin-left: 10px; }
.btn-whatsapp:hover { background-color: #128C7E; }

/* Modal de Notificación Genérico */
.notification-modal .modal-header { border-bottom: none; padding-bottom: 0; }
.notification-modal .modal-body { text-align: center; padding: 2rem; }
.notification-modal .modal-footer { border-top: none; justify-content: center; }
.notification-icon { font-size: 3rem; margin-bottom: 1rem; }
.notification-icon.success { color: #198754; }
.notification-icon.error { color: #dc3545; }
.notification-icon.warning { color: #ffc107; }
.notification-icon.info { color: #0dcaf0; }
.notification-title { font-size: 1.5rem; font-weight: bold; margin-bottom: 1rem; }
.notification-text { font-size: 1rem; margin-bottom: 1.5rem; opacity: 0.9; }

/* Animación de shake para notificaciones importantes */
.modal-shake {
    animation: shake 0.6s ease-in-out;
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); }
    20%, 40%, 60%, 80% { transform: translateX(5px); }
}

/* Transiciones suaves para modales */
.modal.fade .modal-dialog {
    transition: transform 0.4s ease-out, opacity 0.4s ease-out;
}

.modal-alerts .modal-dialog {
    transform: scale(0.8);
    transition: transform 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55), opacity 0.3s ease-out;
}

.modal-alerts.show .modal-dialog {
    transform: scale(1);
}
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <div class="header-actions">
        <div class="stat-card-mini">
            <div id="pendientes-count" class="stat-value">0</div>
            <div class="stat-label">Pendientes</div>
        </div>
        <button class="btn-add-new" id="btnAbrirModalManual"><i class="fa-solid fa-plus"></i> Registrar</button>
        <button class="btn-add-new" style="background-color: #198754;" id="btnAbrirModalImportar"><i class="fa-solid fa-file-csv"></i> Importar</button>
    </div>
</div>

<div class="info-card">
    <div class="toolbar">
        <div><label class="ami-form-label">Buscar</label><input type="text" id="searchInput" class="form-control form-control-dark" placeholder="Buscar en todos los prospectos..."></div>
        <div><label class="ami-form-label">Campaña</label><select id="filtroCampana" class="form-select"><option value="">Todas</option><option>Total</option><option>Pelvica</option><option>Bioescaner</option></select></div>
        <div><label class="ami-form-label">Rango de Fechas</label><input type="text" id="filtroFecha" class="form-control" placeholder="Selecciona un rango..."></div>
    </div>
    <div class="table-responsive">
        <table class="ami-table">
            <thead>
                <tr>
                    <th>Nombre</th><th>Teléfono</th><th>Ciudad</th><th>Estado</th><th>Última Acción</th><th class="col-notas" title="Historial de Notas"><i class="fa-solid fa-note-sticky"></i></th><th>Fecha Carga</th>
                </tr>
            </thead>
            <tbody id="prospectosTableBody"></tbody>
        </table>
    </div>
    <div id="pagination-controls" class="pagination-container"></div>
</div>

<div class="modal fade ami-modal-theme notification-modal modal-notifications" id="modalNotificacion" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="notification-icon" id="notificationIcon"><i class="fas fa-info-circle"></i></div>
                <div class="notification-title" id="notificationTitle">Título</div>
                <div class="notification-text" id="notificationText">Mensaje</div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btnNotificationOk">Aceptar</button>
                <button type="button" class="btn btn-secondary d-none" id="btnNotificationCancel">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme modal-management" id="modalGestionarProspecto" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Gestionar: <span id="nombreProspectoModal"></span></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <form id="formGestionar">
                    <input type="hidden" name="prospecto_id" id="gestionId">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                    
                    <!-- NUEVO CONTENEDOR PARA NOMBRE -->
                    <div id="nombre-sin-nombre-container" class="d-none">
                        <div class="alert alert-warning">
                            <i class="fa-solid fa-exclamation-triangle"></i>
                            <strong>Atención:</strong> Este prospecto no tiene un nombre registrado. Puedes agregarlo aquí.
                        </div>
                        <div class="ami-form-group mb-3">
                            <label class="ami-form-label fw-bold">Nombre del Prospecto:</label>
                            <input type="text" name="nuevo_nombre" id="gestionNuevoNombre" class="form-control" placeholder="Ingresa el nombre completo...">
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 ami-form-group mb-3">
                            <label class="ami-form-label">Estado:</label>
                            <select name="estado" id="gestionEstado" class="form-select" required>
                                <option value="nuevo">Nuevo</option><option value="por confirmar">Por Confirmar</option><option value="agendado">Agendado</option><option value="asistido">Asistido</option><option value="no contesta 1">No Contesta 1</option><option value="no contesta 2">No Contesta 2</option><option value="no contesta 3">No Contesta 3</option><option value="cancelo">Canceló</option><option value="seguimiento">Seguimiento</option><option value="solo informacion">Solo Informacion</option><option value="no interesado">No Interesado</option>
                            </select>
                        </div>
                        <div class="col-md-6 ami-form-group mb-3">
                            <label class="ami-form-label">Acción:</label>
                            <select name="ultima_accion" id="gestionAccion" class="form-select" required>
                                <option value="" disabled selected>-- Selecciona una acción --</option><option>Llamada Realizada</option><option>Whatsapp Enviado</option><option>Confirmado</option><option>Ya Asistio</option><option>Proxima Jornada</option><option>Buzón de voz</option><option>Llamar en 15 Min</option><option>Llamar en 30 Min</option><option>Llamar en 60 Min</option><option>Llamar en 3 horas</option><option>Llamar en 24 horas</option>
                            </select>
                        </div>
                    </div>
                    
                    <div id="agendamiento-container" class="d-none">
                        <hr><h5 class="text-primary">Detalles del Agendamiento</h5>
                        <div class="row">
                            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label fw-bold">Cédula</label><input type="text" name="cedula" id="gestionCedula" class="form-control" required></div>
                            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label fw-bold">Edad</label><input type="number" name="edad" id="gestionEdad" class="form-control" min="1" required></div>
                            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label fw-bold">Sexo</label><select name="sexo" id="gestionSexo" class="form-select" required><option value="" disabled selected>Seleccionar...</option><option value="M">Masculino</option><option value="F">Femenino</option></select></div>
                            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label fw-bold">Jornada</label><select name="jornada_id" id="jornadaSelector" class="form-select" required></select></div>
                            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label fw-bold">Hora</label><input type="time" name="hora_asistencia" id="gestionHora" class="form-control" required></div>
                        </div>
                    </div>

                    <hr><div id="historialNotas"></div>
                    <div class="ami-form-group mt-3"><label class="ami-form-label">Nueva Nota:</label><textarea name="notas" id="gestionNotas" class="form-control" rows="3" placeholder="Detalles de la gestión..."></textarea></div>
                </form>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarGestion">Guardar</button></div>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme modal-generic" id="modalAgregarManual" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Registrar Prospecto</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <form id="formAgregarManual">
                    <input type="hidden" name="action" value="agregar_prospecto_manual">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                    <div class="ami-form-group mb-3"><label>Nombre</label><input type="text" name="nombre" class="form-control" required></div>
                    <div class="ami-form-group mb-3"><label>Teléfono</label><input type="text" name="telefono" class="form-control" required></div>
                    <div class="ami-form-group mb-3"><label>Ciudad</label><input type="text" name="ciudad" class="form-control"></div>
                    
                    <!-- NUEVO: Selector de Origen -->
                    <div class="ami-form-group mb-3">
                        <label>Origen</label>
                        <select name="origen" id="origenSelector" class="form-select" required>
                            <option value="">Seleccionar...</option>
                            <option value="whatsapp">WhatsApp</option>
                            <option value="facebook">Facebook</option>
                            <option value="instagram">Instagram</option>
                            <option value="referido">Referido</option>
                            <option value="otro">Otro</option>
                        </select>
                    </div>

                    <!-- NUEVO: Campo "Especifique" (oculto por defecto) -->
                    <div class="ami-form-group mb-3 d-none" id="campoEspecifique">
                        <label>Especifique:</label>
                        <input type="text" name="origen_otro" id="origenOtro" class="form-control" placeholder="¿Cómo se enteró?">
                    </div>
                    
                    <div class="ami-form-group"><label>Campaña</label><select name="campana" class="form-select" required><option value="">Seleccionar...</option><option>Total</option><option>Pelvica</option><option>Bioescaner</option></select></div>
                </form>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarManual">Registrar</button></div>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme modal-generic" id="modalImportar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Importar CSV</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <form id="formImportar" enctype="multipart/form-data">
                    <input type="hidden" name="action" value="importar_mis_prospectos">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                    <div class="ami-form-group"><label class="ami-form-label">Archivo CSV</label><input type="file" class="form-control" name="archivo_csv" accept=".csv" required></div>
                    <div class="form-text mt-2"><a href="/plantilla_prospectos.csv" download>Descargar plantilla</a></div>
                </form>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarImportar">Importar</button></div>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme modal-alerts" id="modalAlertas" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title"><i class="fa-solid fa-bell" style="color: #ffc107;"></i> Acciones Pendientes</h5></div>
            <div class="modal-body">
                <p>Prospectos que requieren atención:</p>
                <ul id="alerta-prospectos-lista" style="list-style-type: none; padding: 0;"></ul>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-primary" id="btnOkTrabajar">OK, ¡a trabajar!</button></div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://npmcdn.com/flatpickr/dist/l10n/es.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Variables globales
    let todosLosLeads = [], currentPage = 1, currentPaginationData = {}, searchTimeout, alertasPendientes = [];

    // Instancias de modales
    const modales = {
        gestion: new bootstrap.Modal(document.getElementById('modalGestionarProspecto')),
        manual: new bootstrap.Modal(document.getElementById('modalAgregarManual')),
        importar: new bootstrap.Modal(document.getElementById('modalImportar')),
        alertas: new bootstrap.Modal(document.getElementById('modalAlertas'), { backdrop: 'static', keyboard: false }),
        notificacion: new bootstrap.Modal(document.getElementById('modalNotificacion'))
    };

    // Función para aplicar backdrop personalizado
    function aplicarBackdropPersonalizado(modalElement, claseBackdrop) {
        modalElement.addEventListener('shown.bs.modal', function() {
            const backdrop = document.querySelector('.modal-backdrop');
            if (backdrop) backdrop.classList.add(claseBackdrop);
        });
        modalElement.addEventListener('hidden.bs.modal', function() {
            const backdrop = document.querySelector('.modal-backdrop');
            if (backdrop) backdrop.classList.remove(claseBackdrop);
        });
    }

    // Aplicar backdrops personalizados
    aplicarBackdropPersonalizado(document.getElementById('modalAlertas'), 'modal-alerts-backdrop');
    aplicarBackdropPersonalizado(document.getElementById('modalNotificacion'), 'modal-notifications-backdrop');

    // Sistema de notificaciones genérico
    const Notificacion = {
        mostrar: function(tipo, titulo, mensaje, callback = null) {
            const modalElement = document.getElementById('modalNotificacion');
            const notificacionModal = modales.notificacion;
            const iconos = { success: 'fa-check-circle', error: 'fa-exclamation-triangle', warning: 'fa-exclamation-triangle', info: 'fa-info-circle', question: 'fa-question-circle' };
            document.getElementById('notificationIcon').innerHTML = `<i class="fas ${iconos[tipo]}"></i>`;
            document.getElementById('notificationIcon').className = `notification-icon ${tipo}`;
            document.getElementById('notificationTitle').textContent = titulo;
            document.getElementById('notificationText').textContent = mensaje;
            const btnOk = document.getElementById('btnNotificationOk');
            const btnCancel = document.getElementById('btnNotificationCancel');
            let confirmationResult = false;
            const modalHiddenHandler = () => { if (callback) { tipo === 'question' ? callback(confirmationResult) : callback(); } };
            modalElement.addEventListener('hidden.bs.modal', modalHiddenHandler, { once: true });
            if (tipo === 'question') {
                btnCancel.classList.remove('d-none');
                btnOk.textContent = 'Sí';
                btnCancel.textContent = 'No';
                btnOk.onclick = () => { confirmationResult = true; notificacionModal.hide(); };
                btnCancel.onclick = () => { confirmationResult = false; notificacionModal.hide(); };
            } else {
                btnCancel.classList.add('d-none');
                btnOk.textContent = 'Aceptar';
                btnOk.onclick = () => { notificacionModal.hide(); };
            }
            if (tipo === 'error' || tipo === 'warning') {
                modalElement.classList.add('modal-shake');
                setTimeout(() => modalElement.classList.remove('modal-shake'), 600);
            }
            notificacionModal.show();
            if (tipo !== 'question') setTimeout(() => notificacionModal.hide(), 3000);
        },
        exito: (titulo, mensaje, callback) => Notificacion.mostrar('success', titulo, mensaje, callback),
        error: (titulo, mensaje, callback) => Notificacion.mostrar('error', titulo, mensaje, callback),
        advertencia: (titulo, mensaje, callback) => Notificacion.mostrar('warning', titulo, mensaje, callback),
        info: (titulo, mensaje, callback) => Notificacion.mostrar('info', titulo, mensaje, callback),
        confirmar: (titulo, mensaje, callback) => Notificacion.mostrar('question', titulo, mensaje, callback)
    };

    // Configuración de fecha
    flatpickr("#filtroFecha", {
        mode: "range", dateFormat: "Y-m-d", altInput: true, altFormat: "d/m/Y", locale: "es",
        onClose: () => cargarProspectos(1)
    });

    // --- LÓGICA PRINCIPAL ---

    function cargarProspectos(page = 1) {
        currentPage = page;
        const searchTerm = document.getElementById('searchInput').value.trim();
        const params = new URLSearchParams({
            action: 'cargar_mis_prospectos', page: page,
            ...(searchTerm && { search: searchTerm }),
            ...(document.getElementById('filtroCampana').value && {campana: document.getElementById('filtroCampana').value}),
            ...getFechaRango()
        });
        fetch(`/api/prospectos_ajax.php?${params}`).then(res => res.json()).then(data => {
            if (data.success) {
                todosLosLeads = data.data;
                currentPaginationData = data.pagination;
                document.getElementById('pendientes-count').textContent = data.pendientes;
                renderizarTabla();
                renderizarPaginacion(currentPaginationData);
            } else Notificacion.error('Error', data.message);
        });
    }

    function getFechaRango() {
        const fechaRangeStr = document.getElementById('filtroFecha')._flatpickr.input.value;
        if (!fechaRangeStr.includes(' a ')) return {};
        const dates = fechaRangeStr.split(' a ');
        return { fecha_inicio: dates[0].split('/').reverse().join('-'), fecha_fin: dates[1].split('/').reverse().join('-') };
    }

    function renderizarTabla() {
        const tablaBody = document.getElementById('prospectosTableBody');
        tablaBody.innerHTML = '';
        if (!todosLosLeads.length) {
            tablaBody.innerHTML = '<tr><td colspan="7" class="text-center">No se encontraron prospectos.</td></tr>';
            return;
        }
        todosLosLeads.forEach(lead => {
            const fechaCarga = new Date(lead.fecha_creacion).toLocaleDateString('es-ES');
            const telefonoHTML = lead.telefono ? `<span class="telefono-clickable" onclick="event.stopPropagation(); confirmarWhatsApp('${lead.telefono}')">${lead.telefono}</span>` : 'N/A';
            const notasTooltip = (lead.notas || 'Sin notas').replace(/"/g, '&quot;').replace(/\n/g, '&#10;');
            const tipoBadge = lead.tipo === 'Reactivación' ? '<span class="badge bg-info text-dark ms-2">Reactivación</span>' : '';
            
            // --- NUEVO: Mostrar origen debajo de la ciudad ---
            let origenDisplay = 'N/A';
            if (lead.origen) {
                if (lead.origen === 'otro') {
                    origenDisplay = lead.origen_otro ? lead.origen_otro : 'No especificado';
                } else {
                    // Capitalizar primera letra
                    origenDisplay = lead.origen.charAt(0).toUpperCase() + lead.origen.slice(1);
                }
            }

            const tr = document.createElement('tr');
            tr.dataset.lead = JSON.stringify(lead);
            tr.innerHTML = `
                <td>${lead.nombre} ${tipoBadge}<small class="d-block text-white-50">${lead.campana || 'N/A'}</small></td>
                <td>${telefonoHTML}</td>
                <td>
                    ${lead.ciudad || 'N/A'}
                    <small class="d-block text-white-50">Origen: ${origenDisplay}</small>
                </td>
                <td><span class="badge-estado" style="background-color: ${getColorPorEstado(lead.estado)}; color: ${lead.estado === 'no contesta' ? 'black' : 'white'}">${lead.estado}</span></td>
                <td>${lead.ultima_accion || '---'}</td>
                <td class="col-notas"><i class="fa-solid fa-note-sticky" data-bs-toggle="tooltip" data-bs-placement="top" title="${notasTooltip}"></i></td>
                <td>${fechaCarga}</td>
            `;
            tr.addEventListener('click', () => abrirModalGestion(JSON.parse(tr.dataset.lead)));
            tablaBody.appendChild(tr);
        });
        document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(el => new bootstrap.Tooltip(el));
    }

    function renderizarPaginacion(pagination) {
        const container = document.getElementById('pagination-controls');
        if (!pagination || pagination.total_pages <= 1) { container.innerHTML = ''; return; }
        let html = `<span class="pagination-info">Página ${pagination.current_page} de ${pagination.total_pages} (${pagination.total_records} registros)</span>`;
        html += `<button class="pagination-btn ${pagination.current_page === 1 ? 'disabled' : ''}" onclick="cargarPagina(${pagination.current_page - 1})">Anterior</button>`;
        let startPage = Math.max(1, pagination.current_page - 2);
        let endPage = Math.min(pagination.total_pages, pagination.current_page + 2);
        if (startPage > 1) html += `<button class="pagination-btn" onclick="cargarPagina(1)">1</button><span class="pagination-info">...</span>`;
        for (let i = startPage; i <= endPage; i++) {
            html += `<button class="pagination-btn ${i === pagination.current_page ? 'active' : ''}" onclick="cargarPagina(${i})">${i}</button>`;
        }
        if (endPage < pagination.total_pages) html += `<span class="pagination-info">...</span><button class="pagination-btn" onclick="cargarPagina(${pagination.total_pages})">${pagination.total_pages}</button>`;
        html += `<button class="pagination-btn ${pagination.current_page === pagination.total_pages ? 'disabled' : ''}" onclick="cargarPagina(${pagination.current_page + 1})">Siguiente</button>`;
        container.innerHTML = html;
    }

    window.cargarPagina = (page) => { if (page > 0 && page <= currentPaginationData.total_pages) cargarProspectos(page); };

    function abrirModalGestion(lead) {
        const form = document.getElementById('formGestionar');
        form.reset();
        form.querySelector('[name="reactivacion_id"]')?.remove();
        const idField = form.querySelector('[name="cliente_id"]') || form.querySelector('[name="prospecto_id"]');
        idField.name = 'prospecto_id';
        
        document.getElementById('nombreProspectoModal').textContent = lead.nombre;
        idField.value = lead.id;
        document.getElementById('historialNotas').textContent = lead.notas || 'No hay notas anteriores.';
        document.getElementById('gestionEstado').value = lead.estado;
        document.getElementById('gestionAccion').value = lead.ultima_accion || '';
        document.getElementById('gestionCedula').value = lead.cedula || '';
        
        // NUEVA LÓGICA PARA MOSTRAR CAMPO DE NOMBRE
        const nombreContainer = document.getElementById('nombre-sin-nombre-container');
        const nuevoNombreInput = document.getElementById('gestionNuevoNombre');
        
        // Verificar si el nombre es "Sin Nombre" (case insensitive)
        if (lead.nombre && lead.nombre.toLowerCase().trim() === 'sin nombre') {
            nombreContainer.classList.remove('d-none');
            nuevoNombreInput.value = '';
            // Enfocar el campo después de que se abra la modal
            setTimeout(() => nuevoNombreInput.focus(), 500);
        } else {
            nombreContainer.classList.add('d-none');
            nuevoNombreInput.value = '';
        }
        
        document.getElementById('gestionAccion').style.display = 'block';

        if (lead.tipo === 'Reactivación') {
            const reactivacionIdInput = document.createElement('input');
            reactivacionIdInput.type = 'hidden';
            reactivacionIdInput.name = 'reactivacion_id';
            reactivacionIdInput.value = lead.reactivacion_id;
            form.appendChild(reactivacionIdInput);
            idField.name = 'cliente_id';
        }

        document.getElementById('gestionEstado').dispatchEvent(new Event('change'));
        modales.gestion.show();
    }

    document.getElementById('gestionEstado').addEventListener('change', async function() {
        const agendamientoContainer = document.getElementById('agendamiento-container');
        const jornadaSelector = document.getElementById('jornadaSelector');
        if (this.value.toLowerCase() === 'agendado') {
            agendamientoContainer.classList.remove('d-none');
            jornadaSelector.innerHTML = '<option value="">Cargando jornadas...</option>';
            try {
                const response = await fetch('/api/prospectos_ajax.php?action=get_jornadas_asignadas_operador');
                const data = await response.json();
                if (data.success && data.data.length > 0) {
                    jornadaSelector.innerHTML = '<option value="" disabled selected>-- Selecciona una jornada --</option>';
                    data.data.forEach(j => {
                        const fecha = new Date(j.fecha_jornada + 'T00:00:00').toLocaleDateString('es-ES');
                        jornadaSelector.innerHTML += `<option value="${j.id}">${j.ciudad_nombre} (${j.nombre_ruta}) - ${fecha}</option>`;
                    });
                } else {
                    jornadaSelector.innerHTML = '<option value="">No tienes jornadas activas asignadas.</option>';
                }
            } catch (e) {
                jornadaSelector.innerHTML = '<option value="">Error al cargar jornadas.</option>';
            }
        } else {
            agendamientoContainer.classList.add('d-none');
        }
    });

    document.getElementById('btnGuardarGestion').addEventListener('click', function() {
        const form = document.getElementById('formGestionar');
        const estado = document.getElementById('gestionEstado').value;
        const nombreContainer = document.getElementById('nombre-sin-nombre-container');
        const nuevoNombre = document.getElementById('gestionNuevoNombre').value.trim();
        
        // Validar que se haya ingresado un nombre si el contenedor está visible
        if (!nombreContainer.classList.contains('d-none') && !nuevoNombre) {
            Notificacion.advertencia('Atención', 'Por favor, ingresa un nombre para el prospecto antes de continuar.');
            document.getElementById('gestionNuevoNombre').focus();
            return;
        }
        
        let formData = new FormData(form);
        const id = formData.get('prospecto_id') || formData.get('cliente_id');
        const lead = todosLosLeads.find(p => p.id == id);
        
        if (!lead) { 
            Notificacion.error('Error', 'No se pudo encontrar el prospecto para guardar.'); 
            return; 
        }

        let targetUrl = '/api/prospectos_ajax.php';
        let action = '';

        if (lead.tipo === 'Reactivación') {
            targetUrl = '/api/prospectos_reactivacion_ajax.php';
            action = estado.toLowerCase() === 'agendado' ? 'agendar_cliente_reactivacion' : 'actualizar_cliente_reactivacion';
        } else {
            action = estado.toLowerCase() === 'agendado' ? 'agendar_prospecto_a_jornada' : 'actualizar_prospecto_operador';
        }
        formData.set('action', action);
        
        if (estado.toLowerCase() === 'agendado') {
            const camposRequeridos = ['jornada_id', 'cedula', 'edad', 'sexo', 'hora_asistencia'];
            if (camposRequeridos.some(campo => !formData.get(campo))) {
                Notificacion.advertencia('Atención', 'Para agendar, debes completar todos los campos del formulario.');
                return;
            }
        }
        
        fetch(targetUrl, { method: 'POST', body: formData })
        .then(res => res.json()).then(data => {
            if (data.success) {
                modales.gestion.hide();
                Notificacion.exito('¡Éxito!', data.message);
                cargarProspectos(currentPage);
            } else Notificacion.error('Error', data.message);
        }).catch(() => Notificacion.error('Error', 'Error de conexión al guardar cambios.'));
    });

    document.getElementById('btnAbrirModalManual').addEventListener('click', () => {
        document.getElementById('formAgregarManual').reset();
        modales.manual.show();
    });

    document.getElementById('btnGuardarManual').addEventListener('click', () => {
        const formData = new FormData(document.getElementById('formAgregarManual'));
        fetch('/api/prospectos_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
            if (data.success) {
                modales.manual.hide();
                Notificacion.exito('¡Éxito!', data.message);
                cargarProspectos(1);
            } else Notificacion.error('Error', data.message);
        });
    });

    document.getElementById('btnAbrirModalImportar').addEventListener('click', () => {
        document.getElementById('formImportar').reset();
        modales.importar.show();
    });

    document.getElementById('btnGuardarImportar').addEventListener('click', () => {
        const form = document.getElementById('formImportar');
        const formData = new FormData(form);
        if (!form.querySelector('[name="archivo_csv"]').files.length) {
            Notificacion.advertencia('Atención', 'Por favor, selecciona un archivo CSV.');
            return;
        }
        modales.importar.hide();
        Notificacion.info('Procesando...', 'Importando archivo CSV, por favor espera...');
        fetch('/api/prospectos_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
            if (data.success) {
                Notificacion.exito('¡Éxito!', data.message);
                cargarProspectos(1);
            } else Notificacion.error('Error', data.message);
        });
    });

    function verificarAlertas() {
        fetch('/api/prospectos_ajax.php?action=verificar_acciones_pendientes')
        .then(res => res.json())
        .then(data => {
            if (data.success && data.data.length > 0) {
                alertasPendientes = [...data.data];
                mostrarModalAlertas();
            }
        });
    }

    function mostrarModalAlertas() {
        const lista = document.getElementById('alerta-prospectos-lista');
        lista.innerHTML = '';
        alertasPendientes.forEach(p => {
            lista.innerHTML += `<li><div><strong>${p.nombre}</strong> - ${p.ultima_accion} <br><span style="color: #ccc; font-size: 0.9em; vertical-align: middle;"><i class="fa-solid fa-phone-volume"></i> ${p.telefono || 'Sin teléfono'}</span>${p.telefono ? `<button class="btn-whatsapp" onclick="abrirWhatsApp('${p.telefono}')"><i class="fab fa-whatsapp"></i> WhatsApp</button>` : ''}</div></li>`;
        });
        modales.alertas.show();
    }

    function mostrarModalAlertasRestantes() {
        if (alertasPendientes.length > 0) mostrarModalAlertas();
    }

    document.getElementById('btnOkTrabajar').addEventListener('click', function() {
        alertasPendientes = [];
        modales.alertas.hide();
    });

    window.abrirWhatsApp = (telefono) => window.open(`https://wa.me/${telefono}`, '_blank');
    
    window.confirmarWhatsApp = (telefono) => {
        Notificacion.confirmar('Enviar WhatsApp', `¿Deseas enviar un mensaje de WhatsApp al número ${telefono}?`, (confirmado) => {
            if (confirmado) abrirWhatsApp(telefono);
        });
    };

    function getColorPorEstado(estado) {
        const colores = {
            'nuevo': '#6c757d', 'Pendiente': '#6c757d',
            'por confirmar': '#0dcaf0', 'Contactado': '#0dcaf0',
            'agendado': '#fd7e14', 'Agendado': '#fd7e14',
            'asistido': '#198754', 'no contesta': '#ffc107',
            'cancelo': '#dc3545', 'No Interesado': '#dc3545',
            'seguimiento': '#6610f2'
        };
        return colores[estado] || '#6c757d';
    }

    document.getElementById('searchInput').addEventListener('input', () => {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => cargarProspectos(1), 500);
    });
    
    document.getElementById('filtroCampana').addEventListener('change', () => cargarProspectos(1));

    // NUEVO: Lógica para mostrar/ocultar campo "Especifique" cuando se elige "Otro"
    document.getElementById('origenSelector').addEventListener('change', function() {
        const campoEspecifique = document.getElementById('campoEspecifique');
        if (this.value === 'otro') {
            campoEspecifique.classList.remove('d-none');
            document.getElementById('origenOtro').setAttribute('required', 'required');
        } else {
            campoEspecifique.classList.add('d-none');
            document.getElementById('origenOtro').removeAttribute('required');
            document.getElementById('origenOtro').value = ''; // Limpiar si cambia
        }
    });

    // Inicialización
    cargarProspectos();
    setInterval(verificarAlertas, 60000);
});
</script>
<?php include_once 'templates/footer.php'; ?>