<?php
require_once 'includes/seguridad.php'; 

if (!puede('ver_reactivacion_admin')) {
    header('Location: inicio.php?error=acceso_denegado');
    exit();
}

$page_title = 'Campañas de Reactivación de Clientes';
include_once 'templates/header.php';
?>

<style>
    #contador-seleccion {
        font-weight: bold;
        color: var(--primary-color);
    }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="info-card">
    <h5 class="mb-3"><i class="fa-solid fa-filter me-2"></i>Filtrar Base de Datos de Clientes</h5>
    <form id="form-filtrar-clientes">
        <div class="row">
            <div class="col-md-4 mb-3">
                <label class="ami-form-label">Ciudad</label>
                <input type="text" name="ciudad" class="form-control form-control-dark" placeholder="Ej: Valencia">
            </div>
            <div class="col-md-4 mb-3">
                <label class="ami-form-label">Contactado por última vez antes de:</label>
                <input type="date" name="fecha_ultimo_contacto" class="form-control form-control-dark">
            </div>
            <div class="col-md-4 d-flex align-items-end mb-3">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fa-solid fa-search me-2"></i>Buscar Clientes
                </button>
            </div>
        </div>
    </form>
</div>

<div class="info-card mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Resultados de la Búsqueda</h5>
        <?php if (puede('crear_lote_reactivacion')): ?>
        <button id="btn-crear-lote" class="btn btn-success" disabled>
            <i class="fa-solid fa-layer-group me-2"></i>Crear Lote con <span id="contador-seleccion">0</span> seleccionados
        </button>
        <?php endif; ?>
    </div>
    
    <div id="resultados-container">
        <p class="text-center text-white-50">Utilice los filtros para buscar clientes.</p>
    </div>
</div>


<div class="modal fade ami-modal-theme" id="modalCrearLote" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Crear y Asignar Lote de Reactivación</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="formCrearLote">
            <div class="mb-3">
                <label class="ami-form-label">Nombre del Lote</label>
                <input type="text" name="nombre_lote" class="form-control" required placeholder="Ej: Reactivación Valencia - Octubre 2025">
            </div>
            <div class="mb-3">
                <label class="ami-form-label">Asignar a Supervisor</label>
                <select name="supervisor_id" id="select-supervisor" class="form-select" required>
                    <option value="">Cargando supervisores...</option>
                </select>
            </div>
            <p>Se asignarán <strong id="total-clientes-lote" class="text-primary">0</strong> clientes a este lote.</p>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-primary" id="btnConfirmarLote">Confirmar y Asignar</button>
      </div>
    </div>
  </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const modalCrearLote = new bootstrap.Modal(document.getElementById('modalCrearLote'));
    const formFiltrar = document.getElementById('form-filtrar-clientes');
    const resultadosContainer = document.getElementById('resultados-container');
    const btnCrearLote = document.getElementById('btn-crear-lote');
    const contadorSeleccion = document.getElementById('contador-seleccion');
    const totalClientesLote = document.getElementById('total-clientes-lote');
    
    let seleccionados = [];

    function cargarSupervisores() {
        const select = document.getElementById('select-supervisor');
        fetch('/api/reactivacion_ajax.php?action=get_supervisores')
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                select.innerHTML = '<option value="">-- Seleccione un Supervisor --</option>';
                data.data.forEach(supervisor => {
                    select.innerHTML += `<option value="${supervisor.id}">${supervisor.nombre}</option>`;
                });
            } else {
                select.innerHTML = '<option value="">Error al cargar supervisores</option>';
            }
        });
    }

    formFiltrar.addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(this);
        formData.append('action', 'buscar_clientes_reactivacion');
        formData.append('csrf_token', csrfToken);
        
        resultadosContainer.innerHTML = '<p class="text-center text-white-50">Buscando...</p>';

        fetch('/api/reactivacion_ajax.php', {
            method: 'POST',
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if (!data.success) {
                Swal.fire('Error', data.message, 'error');
                resultadosContainer.innerHTML = `<p class="text-center text-danger">${data.message}</p>`;
                return;
            }
            renderizarResultados(data.data);
        })
        .catch(error => {
            Swal.fire('Error', 'No se pudo conectar con el servidor.', 'error');
            console.error(error);
        });
    });

    function renderizarResultados(clientes) {
        seleccionados = [];
        actualizarEstadoSeleccion();
        if (clientes.length === 0) {
            resultadosContainer.innerHTML = '<p class="text-center text-white-50">No se encontraron clientes con esos criterios.</p>';
            return;
        }

        const tablaHeader = `
            <table class="ami-table">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="seleccionar-todos"></th>
                        <th>Nombre</th>
                        <th>Cédula</th>
                        <th>Teléfono</th>
                        <th>Ciudad de Origen</th>
                        <th>Estado Global</th>
                    </tr>
                </thead>
                <tbody>
        `;

        const tablaFooter = `
                </tbody>
            </table>
        `;

        const filasHtml = clientes.map(cliente => `
            <tr>
                <td><input class="form-check-input" type="checkbox" value="${cliente.id}" data-cliente-id="${cliente.id}"></td>
                <td><strong>${cliente.nombre}</strong></td>
                <td>${cliente.cedula}</td>
                <td>${cliente.telefono || 'N/A'}</td>
                <td>${cliente.ciudad_origen || 'N/A'}</td>
                <td><span class="badge bg-info text-dark">${cliente.estado_global || 'N/A'}</span></td>
            </tr>
        `).join('');

        resultadosContainer.innerHTML = tablaHeader + filasHtml + tablaFooter;
    }

    resultadosContainer.addEventListener('change', function(e) {
        if (e.target.matches('input[type="checkbox"]')) {
            if (e.target.id === 'seleccionar-todos') {
                const checkboxes = resultadosContainer.querySelectorAll('input[type="checkbox"][data-cliente-id]');
                checkboxes.forEach(cb => cb.checked = e.target.checked);
            }
            actualizarEstadoSeleccion();
        }
    });

    function actualizarEstadoSeleccion() {
        const checkboxes = resultadosContainer.querySelectorAll('input[type="checkbox"][data-cliente-id]:checked');
        seleccionados = Array.from(checkboxes).map(cb => cb.value);
        
        if(contadorSeleccion){
            contadorSeleccion.textContent = seleccionados.length;
        }
        if(btnCrearLote){
            btnCrearLote.disabled = seleccionados.length === 0;
        }
    }

    if(btnCrearLote){
        btnCrearLote.addEventListener('click', function() {
            if (seleccionados.length > 0) {
                totalClientesLote.textContent = seleccionados.length;
                modalCrearLote.show();
            }
        });
    }

    document.getElementById('btnConfirmarLote').addEventListener('click', function() {
        const formLote = document.getElementById('formCrearLote');
        const formData = new FormData(formLote);
        formData.append('action', 'crear_lote_reactivacion');
        formData.append('csrf_token', csrfToken);
        formData.append('clientes_ids', JSON.stringify(seleccionados));

        if (!formData.get('nombre_lote') || !formData.get('supervisor_id')) {
            Swal.fire('Atención', 'Debe darle un nombre al lote y seleccionar un supervisor.', 'warning');
            return;
        }

        fetch('/api/reactivacion_ajax.php', {
            method: 'POST',
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                modalCrearLote.hide();
                Swal.fire('¡Éxito!', data.message, 'success');
                formFiltrar.dispatchEvent(new Event('submit'));
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        });
    });

    cargarSupervisores();
});
</script>

<?php include_once 'templates/footer.php'; ?>