<?php
require_once 'includes/seguridad.php'; 
$page_title = 'Asignar Operadores a Jornadas';
include_once 'templates/header.php';

if (!puede('gestionar_rutas_admin')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}

$operadores = $conn->query("SELECT id, nombre, foto_perfil FROM usuarios WHERE rol_id IN (SELECT id FROM roles WHERE clave = 'operador') AND estado = 1 ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
$operadores_json = json_encode($operadores);
?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />

<style>
    /* --- ESTILOS MEJORADOS PARA LA INTERFAZ --- */
    .equipo-resumen {
        display: flex;
        align-items: center;
        padding-left: 10px;
    }
    .equipo-resumen img {
        width: 40px;  /* ✅ FOTO MÁS GRANDE */
        height: 40px;
        border-radius: 50%;
        margin-left: -12px; /* Efecto de apilamiento ajustado */
        border: 3px solid var(--sidebar-bg); /* Borde más grueso para mejor separación */
        object-fit: cover;
        transition: transform 0.2s ease-in-out, z-index 0s 0.1s; /* ✅ ANIMACIÓN SUAVE */
        cursor: pointer;
    }
    .equipo-resumen img:hover {
        transform: scale(1.5) translateZ(0); /* ✅ EFECTO DE ZOOM AL PASAR EL RATÓN */
        z-index: 10;
    }
    .select2-operator-option { display: flex; align-items: center; padding: 5px; }
    .select2-operator-img { width: 40px; height: 40px; border-radius: 50%; margin-right: 12px; object-fit: cover; }
    .select2-selection__choice img { width: 20px; height: 20px; border-radius: 50%; margin-right: 8px; object-fit: cover; }
    .select2-container--bootstrap-5 .select2-selection { background-color: rgba(15, 23, 42, 0.7) !important; border: 1px solid #475569 !important; }
    .select2-container--bootstrap-5 .select2-dropdown { background-color: var(--sidebar-bg); border-color: var(--border-color); }
    .select2-container--bootstrap-5 .select2-selection--multiple .select2-selection__choice { background-color: rgba(var(--primary-color-rgb), 0.2) !important; color: var(--light-text) !important; border: 1px solid var(--primary-color) !important; display: inline-flex; align-items: center; }
</style>

<div class="main-header">
    <div>
        <a href="rutas-admin.php" class="btn btn-outline-light mb-2"><i class="fa-solid fa-arrow-left"></i> Volver a Rutas</a>
        <h1><?php echo $page_title; ?></h1>
    </div>
</div>

<div class="info-card">
    <div class="row">
        <div class="col-md-6 ami-form-group">
            <label for="rutaSelector" class="form-label">1. Seleccione una Ruta</label>
            <select id="rutaSelector" class="form-select form-control-dark"></select>
        </div>
    </div>
</div>

<div id="jornadas-container" class="info-card mt-4 d-none">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>2. Asigne el equipo para cada jornada</h4>
        <input type="text" id="jornadaSearchInput" class="form-control form-control-dark" style="max-width: 300px;" placeholder="Buscar jornada por ciudad...">
    </div>
    <hr>
    <div class="table-responsive">
        <table class="ami-table">
            <thead>
                <tr>
                    <th style="width: 50px;" class="text-center">#</th>
                    <th>Ciudad</th>
                    <th>Fecha</th>
                    <th>Equipo Asignado</th>
                    <th class="text-end">Acciones</th>
                </tr>
            </thead>
            <tbody id="jornadas-table-body"></tbody>
        </table>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalAsignar" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header"><h5 class="modal-title">Asignar Equipo para <span id="modal-jornada-titulo" class="text-primary"></span></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
      <div class="modal-body">
        <input type="hidden" id="modal-jornada-id">
        <div class="ami-form-group"><label class="ami-form-label">Operadores</label><select id="modal-operadores-select" class="form-select" multiple="multiple" style="width: 100%;"></select></div>
      </div>
      <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarAsignacionModal">Guardar Cambios</button></div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const todosLosOperadores = <?php echo $operadores_json; ?>;
    let jornadasData = [];
    const modalAsignar = new bootstrap.Modal(document.getElementById('modalAsignar'));

    function formatOperatorState(state) {
        if (!state.id) return state.text;
        const operatorData = todosLosOperadores.find(op => op.id == state.id);
        if (!operatorData) return state.text;
        const fotoSrc = operatorData.foto_perfil ? `/uploads/perfiles/${operatorData.foto_perfil}` : '/uploads/perfiles/default.png';
        return $(`<span class="select2-operator-option"><img src="${fotoSrc}" class="select2-operator-img" /><span>${operatorData.nombre}</span></span>`);
    }

    $('#modal-operadores-select').select2({
        theme: "bootstrap-5", width: '100%', placeholder: "Seleccione operadores",
        templateResult: formatOperatorState, templateSelection: formatOperatorState,
        escapeMarkup: (m) => m, dropdownParent: $('#modalAsignar .modal-body')
    });

    async function cargarRutas() {
        const response = await fetch('/api/rutas_ajax.php?action=get_rutas_para_asignacion');
        const data = await response.json();
        if (data.success) {
            const selector = document.getElementById('rutaSelector');
            selector.innerHTML = '<option value="">-- Seleccione una ruta --</option>';
            data.data.forEach(ruta => selector.innerHTML += `<option value="${ruta.id}">${ruta.nombre_ruta}</option>`);
        }
    }

    function renderizarTablaJornadas(filtro = '') {
        const tbody = document.getElementById('jornadas-table-body');
        tbody.innerHTML = '';
        
        const jornadasFiltradas = jornadasData.filter(j => j.ciudad_nombre.toLowerCase().includes(filtro.toLowerCase()));

        if (jornadasFiltradas.length === 0) {
            tbody.innerHTML = `<tr><td colspan="5" class="text-center">${filtro ? 'No se encontraron jornadas con ese nombre.' : 'Esta ruta no tiene jornadas definidas.'}</td></tr>`;
            return;
        }

        jornadasFiltradas.forEach((jornada, index) => {
            const fecha = new Date(jornada.fecha_jornada + 'T00:00:00').toLocaleDateString('es-ES');
            let equipoHtml = '<span class="text-white-50">Ninguno</span>';
            if (jornada.operadores_asignados.length > 0) {
                equipoHtml = '<div class="equipo-resumen">';
                jornada.operadores_asignados.forEach(opId => {
                    const opData = todosLosOperadores.find(op => op.id == opId);
                    if (opData) {
                        const fotoSrc = opData.foto_perfil ? `/uploads/perfiles/${opData.foto_perfil}` : '/uploads/perfiles/default.png';
                        equipoHtml += `<img src="${fotoSrc}" title="${opData.nombre}" onerror="this.src='/uploads/perfiles/default.png'">`;
                    }
                });
                equipoHtml += '</div>';
            }

            tbody.innerHTML += `
                <tr id="jornada-row-${jornada.id}">
                    <td class="text-center"><strong>${index + 1}</strong></td>
                    <td>${jornada.ciudad_nombre}</td>
                    <td>${fecha}</td>
                    <td>${equipoHtml}</td>
                    <td class="text-end">
                        <button class="btn btn-sm btn-outline-light" onclick="abrirModalAsignacion(${jornada.id})">
                            <i class="fa-solid fa-users-cog"></i> Gestionar Equipo
                        </button>
                    </td>
                </tr>`;
        });
    }

    document.getElementById('rutaSelector').addEventListener('change', async function() {
        const rutaId = this.value;
        const container = document.getElementById('jornadas-container');
        document.getElementById('jornadaSearchInput').value = ''; // Limpiar búsqueda al cambiar de ruta
        if (!rutaId) { container.classList.add('d-none'); return; }

        const response = await fetch(`/api/rutas_ajax.php?action=get_jornadas_para_asignacion&ruta_id=${rutaId}`);
        const data = await response.json();
        if (data.success) {
            jornadasData = data.data;
            renderizarTablaJornadas();
            container.classList.remove('d-none');
        } else { Swal.fire('Error', data.message, 'error'); }
    });
    
    // ✅ EVENTO PARA EL BUSCADOR EN TIEMPO REAL
    document.getElementById('jornadaSearchInput').addEventListener('keyup', function() {
        renderizarTablaJornadas(this.value);
    });

    window.abrirModalAsignacion = function(jornadaId) {
        const jornada = jornadasData.find(j => j.id === jornadaId);
        if (!jornada) return;
        document.getElementById('modal-jornada-titulo').textContent = jornada.ciudad_nombre;
        document.getElementById('modal-jornada-id').value = jornada.id;
        const select = $('#modal-operadores-select');
        select.html('');
        todosLosOperadores.forEach(op => {
            select.append(new Option(op.nombre, op.id, false, false));
        });
        select.val(jornada.operadores_asignados).trigger('change');
        modalAsignar.show();
    }

    document.getElementById('btnGuardarAsignacionModal').addEventListener('click', async function() {
        const jornadaId = document.getElementById('modal-jornada-id').value;
        const operadoresIds = $('#modal-operadores-select').val();
        Swal.fire({ title: 'Guardando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
        const formData = new FormData();
        formData.append('action', 'guardar_asignacion_jornada');
        formData.append('jornada_id', jornadaId);
        (operadoresIds || []).forEach(id => formData.append('operadores_ids[]', id));
        formData.append('csrf_token', csrfToken);
        const response = await fetch('/api/rutas_ajax.php', { method: 'POST', body: formData });
        const data = await response.json();
        Swal.close();
        if (data.success) {
            modalAsignar.hide();
            Swal.fire({ toast: true, position: 'top-end', icon: 'success', title: data.message, showConfirmButton: false, timer: 2000 });
            const jornadaIndex = jornadasData.findIndex(j => j.id == jornadaId);
            if (jornadaIndex > -1) {
                jornadasData[jornadaIndex].operadores_asignados = operadoresIds || [];
                renderizarTablaJornadas(document.getElementById('jornadaSearchInput').value); // Re-renderizar con filtro actual
            }
        } else { Swal.fire('Error', data.message, 'error'); }
    });

    cargarRutas();
});
</script>

<?php include_once 'templates/footer.php'; ?>