<?php
require_once 'includes/seguridad.php'; 
$page_title = 'Crear Nueva Ruta de Viaje';
include_once 'templates/header.php';

if (!puede('gestionar_rutas_admin')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}

// Cargar todo el personal necesario para los selectores
$coordinadores = $conn->query("SELECT id, nombre FROM usuarios WHERE rol_id IN (SELECT id FROM roles WHERE clave = 'coordinador') AND estado = 1 ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
$doctores = $conn->query("SELECT id, nombre FROM usuarios WHERE rol_id IN (SELECT id FROM roles WHERE clave = 'doctor') AND estado = 1 ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
$choferes = $conn->query("SELECT id, nombre FROM usuarios WHERE rol_id IN (SELECT id FROM roles WHERE clave = 'chofer') AND estado = 1 ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<style>
    .jornada-card {
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid var(--border-color);
        border-radius: 15px;
        margin-bottom: 1.5rem;
        padding: 1.5rem;
    }
</style>

<div class="main-header">
    <div>
        <a href="rutas-admin.php" class="btn btn-outline-light mb-2"><i class="fa-solid fa-arrow-left"></i> Volver al Listado</a>
        <h1><?php echo $page_title; ?></h1>
    </div>
</div>

<form id="formCrearRuta">
    <div class="info-card mb-4">
        <h4>1. Datos Generales y Personal de la Ruta</h4>
        <hr>
        <div class="row">
            <div class="col-md-12 ami-form-group mb-3">
                <label class="ami-form-label" for="nombre_ruta">Nombre de la Ruta</label>
                <input type="text" id="nombre_ruta" name="nombre_ruta" class="ami-form-control" placeholder="Ej: Gira Los Andes - Octubre 2025" required>
            </div>
            <div class="col-md-4 ami-form-group mb-3">
                <label class="ami-form-label" for="coordinador_id">Coordinador de Campo (Opcional)</label>
                <select name="coordinador_id" id="coordinador_id" class="ami-form-control form-select">
                    <option value="">Sin asignar</option>
                    <?php foreach ($coordinadores as $coordinador): ?>
                        <option value="<?php echo $coordinador['id']; ?>"><?php echo htmlspecialchars($coordinador['nombre']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4 ami-form-group mb-3">
                <label class="ami-form-label" for="doctor_id">Doctor Asignado (Opcional)</label>
                <select name="doctor_id" id="doctor_id" class="ami-form-control form-select">
                    <option value="">Sin asignar</option>
                    <?php foreach ($doctores as $doctor): ?>
                        <option value="<?php echo $doctor['id']; ?>"><?php echo htmlspecialchars($doctor['nombre']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4 ami-form-group mb-3">
                <label class="ami-form-label" for="chofer_id">Chofer Asignado (Opcional)</label>
                <select name="chofer_id" id="chofer_id" class="ami-form-control form-select">
                    <option value="">Sin asignar</option>
                    <?php foreach ($choferes as $chofer): ?>
                        <option value="<?php echo $chofer['id']; ?>"><?php echo htmlspecialchars($chofer['nombre']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
    </div>

    <div class="info-card">
        <h4>2. Jornadas (Ciudades y Fechas)</h4>
        <hr>
        <p class="text-white-50 small">Define las ciudades y fechas que compondrán esta ruta. Podrás asignar los operadores y gestionar los suministros en los módulos correspondientes.</p>
        <div id="jornadas-container" class="mt-3">
        </div>
        <button type="button" class="btn btn-outline-success mt-3" id="btn-add-jornada"><i class="fa-solid fa-plus"></i> Agregar Jornada</button>
    </div>

    <div class="mt-4">
        <button type="submit" class="btn-add-new btn-lg"><i class="fa-solid fa-save"></i> Guardar Ruta</button>
    </div>
</form>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://npmcdn.com/flatpickr/dist/l10n/es.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let jornadaCounter = 0;
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';

    function inicializarDatepicker(selector) {
        flatpickr(selector, {
            altInput: true,
            altFormat: "d/m/Y",
            dateFormat: "Y-m-d",
            "locale": "es"
        });
    }

    function agregarJornada() {
        jornadaCounter++;
        const container = document.getElementById('jornadas-container');
        const jornadaHtml = `
            <div class="jornada-card" id="jornada-card-${jornadaCounter}">
                <div class="row align-items-center">
                    <div class="col-md-5"><input type="text" name="jornadas[${jornadaCounter}][ciudad]" class="ami-form-control" placeholder="Nombre de la Ciudad" required></div>
                    <div class="col-md-5"><input type="text" name="jornadas[${jornadaCounter}][fecha]" class="ami-form-control datepicker" placeholder="Seleccionar fecha..." required></div>
                    <div class="col-md-2 text-end"><button type="button" class="btn btn-danger" onclick="this.closest('.jornada-card').remove()">Eliminar</button></div>
                </div>
            </div>
        `;
        container.insertAdjacentHTML('beforeend', jornadaHtml);
        inicializarDatepicker(`#jornada-card-${jornadaCounter} .datepicker`);
    }
    
    document.getElementById('btn-add-jornada').addEventListener('click', agregarJornada);
    
    agregarJornada();

    document.getElementById('formCrearRuta').addEventListener('submit', function(e) {
        e.preventDefault();
        Swal.fire({ title: 'Guardando...', text: 'Por favor espera.', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
        const formData = new FormData(this);
        formData.append('action', 'crear_ruta_completa_simple');
        formData.append('csrf_token', csrfToken);
        
        fetch('/api/rutas_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json()).then(data => {
            if (data.success) {
                Swal.fire('¡Ruta Creada!', data.message, 'success').then(() => { window.location.href = 'rutas-admin.php'; });
            } else { Swal.fire('Error', data.message, 'error'); }
        });
    });
});
</script>

<?php include_once 'templates/footer.php'; ?>