<?php
require_once 'includes/seguridad.php'; 
if (puede('supervisar_todos_operadores')) {
    $page_title = 'Monitor Global de Operadores';
    $page_subtitle = 'Visualizando la actividad de todos los asesores del sistema.';
} else {
    $page_title = 'Dashboard de Supervisor';
    $page_subtitle = 'Aquí tienes un resumen del rendimiento de tu equipo.';
}
include_once 'templates/header.php';

if (!puede('ver_dashboard_supervisor') && !puede('supervisar_todos_operadores')) {
    echo "<main class='ami-content'><div class='info-card text-center'><h1><i class='fa-solid fa-ban' style='color: #dc3545;'></i> Acceso Denegado</h1><p>No tienes permiso para ver esta página.</p></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>
<style>
    .dashboard-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 1.5rem; }
    .stat-card { background: var(--card-bg); padding: 1.5rem; border-radius: 15px; border: 1px solid var(--border-color); text-align: center; }
    .stat-card .stat-value { font-size: 2.8rem; font-weight: 700; color: var(--primary-color); }
    .stat-card .stat-label { font-size: 0.9rem; opacity: 0.8; margin-top: -5px; }
    .info-card h5 { font-weight: 600; color: var(--primary-color); margin-bottom: 1rem; border-bottom: 1px solid var(--border-color); padding-bottom: 0.5rem; }
    .activity-list-item { display: flex; justify-content: space-between; align-items: center; padding: 0.75rem 0; border-bottom: 1px solid rgba(120, 227, 32, 0.1); }
    .activity-list-item:last-child { border-bottom: none; }
    .info-card.expandable { cursor: pointer; transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out; }
    .info-card.expandable:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0,0,0,0.2); }
    #modalActividadCompleta .modal-dialog { max-width: 95%; width: auto !important; margin: 1.75rem auto; }
    .modal-body { max-height: 75vh; overflow-y: auto; }
    .asesor-card { display: flex; align-items: center; gap: 1rem; background: rgba(0,0,0,0.2); padding: 1rem; border-radius: 10px; margin-bottom: 1rem; }
    .asesor-card img { width: 50px; height: 50px; border-radius: 50%; object-fit: cover; border: 2px solid var(--border-color); }
    .asesor-card .info { flex-grow: 1; }
    .asesor-card .info h6 { margin: 0; color: var(--light-text); }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <p class="lead">Bienvenido, <?php echo htmlspecialchars($usuario_actual['nombre']); ?>. <?php echo $page_subtitle; ?></p>
</div>

<div class="dashboard-grid mb-4">
    <div class="stat-card">
        <div id="total-prospectos" class="stat-value">...</div>
        <div class="stat-label">Prospectos Totales</div>
    </div>
    <div class="stat-card">
        <div id="prospectos-nuevos" class="stat-value">...</div>
        <div class="stat-label">Sin Gestionar</div>
    </div>
    <div class="stat-card">
        <div id="gestionados-hoy" class="stat-value">...</div>
        <div class="stat-label">Gestionados Hoy</div>
    </div>
</div>

<div class="dashboard-grid">
    <div class="info-card expandable" data-bs-toggle="modal" data-bs-target="#modalActividadCompleta">
        <h5><i class="fa-solid fa-bolt"></i> Actividad Reciente <small class="text-white-50">(clic para ver todo)</small></h5>
        <div id="actividad-reciente-lista"></div>
    </div>
    <div class="info-card">
        <h5><i class="fa-solid fa-chart-line"></i> Rendimiento del Día</h5>
        <table class="ami-table performance-table">
            <thead><tr><th>Asesor</th><th class="text-center">Gestionados Hoy</th></tr></thead>
            <tbody id="rendimiento-dia-body"></tbody>
        </table>
    </div>
    <div class="info-card">
        <h5><i class="fa-solid fa-map-location-dot"></i> Rendimiento por Jornada</h5>
        <table class="ami-table performance-table">
            <thead><tr><th>Jornada</th><th class="text-center">Agendados</th></tr></thead>
            <tbody id="rendimiento-jornada-body"></tbody>
        </table>
    </div>
</div>

<div class="info-card mt-4">
    <h5><i class="fa-solid fa-users"></i> Equipo de Asesores</h5>
    <div id="equipo-asesores-container" class="mt-3"></div>
</div>

<div class="modal fade ami-modal-theme" id="modalActividadCompleta" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Registro Completo de Actividad</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <div class="toolbar mb-3"><input type="text" id="searchActividadInput" class="form-control form-control-dark" placeholder="Buscar..."></div>
                <div class="table-responsive">
                    <table class="ami-table">
                        <thead><tr><th>Prospecto</th><th>Teléfono</th><th>Asesor</th><th>Estado</th><th>Última Acción</th><th>Fecha</th></tr></thead>
                        <tbody id="actividadCompletaBody"></tbody>
                    </table>
                </div>
                <div id="pagination-controls-modal" class="pagination-container mt-3"></div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modalActividadElement = document.getElementById('modalActividadCompleta');
    let searchTimeout;
    let actividadInterval;

    function cargarDashboard() {
        fetch('/api/supervisor_ajax.php?action=cargar_dashboard_supervisor')
        .then(res => res.ok ? res.json() : Promise.reject(new Error(`Error HTTP ${res.status}: ${res.statusText}`)))
        .then(data => {
            // --- MODIFICACIÓN CLAVE: Mostrar el error específico si el success es false ---
            if (data.success) {
                actualizarUI(data.data);
            } else {
                Swal.fire('Error al Cargar Datos', data.message, 'error');
            }
        })
        .catch(error => {
            console.error('Error en fetch:', error);
            Swal.fire('Error de Conexión', 'No se pudo cargar la información del dashboard. ' + error.message, 'error');
        });
    }

    function actualizarUI(data) {
        document.getElementById('total-prospectos').textContent = data.total_prospectos || 0;
        document.getElementById('prospectos-nuevos').textContent = data.prospectos_nuevos || 0;
        document.getElementById('gestionados-hoy').textContent = data.prospectos_gestionados_hoy || 0;

        const actividadContainer = document.getElementById('actividad-reciente-lista');
        actividadContainer.innerHTML = '';
        if (data.actividad_reciente && data.actividad_reciente.length > 0) {
            data.actividad_reciente.forEach(act => {
                const fecha = new Date(act.fecha_ultima_llamada).toLocaleString('es-ES', { day: 'numeric', month: 'short', hour: '2-digit', minute: '2-digit' });
                actividadContainer.innerHTML += `<div class="activity-list-item"><div><strong>${act.operador_nombre}</strong> gestionó a <em>${act.nombre}</em><br><small><strong>Acción:</strong> ${act.ultima_accion}</small></div><small class="text-white-50">${fecha}</small></div>`;
            });
        } else {
            actividadContainer.innerHTML = '<p class="text-center text-white-50 small mt-3">Sin actividad reciente.</p>';
        }
        
        const rendimientoDiaBody = document.getElementById('rendimiento-dia-body');
        const equipoContainer = document.getElementById('equipo-asesores-container');
        rendimientoDiaBody.innerHTML = '';
        equipoContainer.innerHTML = '';
        
        if (data.rendimiento_equipo && data.rendimiento_equipo.length > 0) {
            data.rendimiento_equipo.forEach(op => {
                rendimientoDiaBody.innerHTML += `<tr><td>${op.operador_nombre}</td><td class="text-center fw-bold fs-5">${op.gestionados_hoy_operador || 0}</td></tr>`;
                
                const fotoSrc = op.foto_perfil ? `/uploads/perfiles/${op.foto_perfil}` : '/uploads/perfiles/default.png';
                equipoContainer.innerHTML += `
                    <div class="asesor-card">
                        <img src="${fotoSrc}" alt="Foto de ${op.operador_nombre}">
                        <div class="info">
                            <h6>${op.operador_nombre}</h6>
                            <small class="text-white-50">Gestionados Hoy: ${op.gestionados_hoy_operador || 0} | Total: ${op.gestionados}/${op.total_asignados}</small>
                        </div>
                        <a href="supervisor_detalle_asesor.php?id=${op.id}" class="btn btn-outline-light">Ver Detalles</a>
                    </div>
                `;
            });
        } else {
            const mensaje = '<tr><td colspan="2" class="text-center text-white-50 small">No hay operadores en tu equipo.</td></tr>';
            rendimientoDiaBody.innerHTML = mensaje;
            equipoContainer.innerHTML = '<p class="text-center text-white-50 small">No hay operadores en tu equipo.</p>';
        }

        const rendimientoJornadaBody = document.getElementById('rendimiento-jornada-body');
        rendimientoJornadaBody.innerHTML = '';
        if (data.rendimiento_jornadas && data.rendimiento_jornadas.length > 0) {
            data.rendimiento_jornadas.forEach(jornada => {
                rendimientoJornadaBody.innerHTML += `<tr><td>${jornada.ciudad_nombre}</td><td class="text-center fw-bold fs-5">${jornada.agendados}</td></tr>`;
            });
        } else {
            rendimientoJornadaBody.innerHTML = '<tr><td colspan="2" class="text-center text-white-50 small">No hay jornadas activas con agendados.</td></tr>';
        }
    }

    if (modalActividadElement) {
        modalActividadElement.addEventListener('shown.bs.modal', () => {
            cargarActividadCompleta(1);
            actividadInterval = setInterval(() => cargarActividadCompleta(1, false), 15000);
        });
        modalActividadElement.addEventListener('hidden.bs.modal', () => {
            clearInterval(actividadInterval);
        });
    }
    
    window.cargarActividadCompleta = function(page = 1, showLoading = true) {
        const search = document.getElementById('searchActividadInput').value;
        let url = `/api/supervisor_ajax.php?action=cargar_actividad_completa_equipo&page=${page}`;
        if (search) url += `&search=${encodeURIComponent(search)}`;

        fetch(url)
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    renderizarTablaActividad(data.data);
                    renderizarPaginacionModal(data.pagination);
                } else {
                    document.getElementById('actividadCompletaBody').innerHTML = `<tr><td colspan="6" class="text-center text-danger">${data.message}</td></tr>`;
                }
            });
    }

    function renderizarTablaActividad(actividades) {
        const tablaBody = document.getElementById('actividadCompletaBody');
        tablaBody.innerHTML = '';
        if (!actividades || actividades.length === 0) {
            tablaBody.innerHTML = '<tr><td colspan="6" class="text-center">No se encontraron registros.</td></tr>';
            return;
        }
        tablaBody.innerHTML = actividades.map(act => {
            const fecha = new Date(act.fecha_ultima_llamada).toLocaleString('es-ES', {dateStyle: 'short', timeStyle: 'short'});
            const telefonoHTML = act.telefono ? `<span class="telefono-ofuscado" title="Clic para revelar" onclick="revelarTelefono(this, '${act.telefono}')">${ofuscarTelefono(act.telefono)}</span>` : 'N/A';
            const estadoColor = getColorPorEstado(act.estado);
            return `
                <tr>
                    <td>${act.nombre}</td>
                    <td>${telefonoHTML}</td>
                    <td>${act.operador_nombre}</td>
                    <td><span class="badge" style="background-color: ${estadoColor.bg}; color: ${estadoColor.text}">${act.estado}</span></td>
                    <td>${act.ultima_accion || 'N/A'}</td>
                    <td>${fecha}</td>
                </tr>`;
        }).join('');
    }
    
    function renderizarPaginacionModal(pagination) {
        const container = document.getElementById('pagination-controls-modal');
        container.innerHTML = '';
        if (!pagination || pagination.total_pages <= 1) return;

        let html = `<span class="pagination-info">Página ${pagination.current_page} de ${pagination.total_pages}</span>`;
        html += `<button class="pagination-btn ${pagination.current_page === 1 ? 'disabled' : ''}" onclick="cargarActividadCompleta(${pagination.current_page - 1})">Anterior</button>`;
        
        let startPage = Math.max(1, pagination.current_page - 2);
        let endPage = Math.min(pagination.total_pages, pagination.current_page + 2);

        if (startPage > 1) html += `<button class="pagination-btn" onclick="cargarActividadCompleta(1)">1</button><span class="pagination-info">...</span>`;
        for (let i = startPage; i <= endPage; i++) {
            html += `<button class="pagination-btn ${i === pagination.current_page ? 'active' : ''}" onclick="cargarActividadCompleta(${i})">${i}</button>`;
        }
        if (endPage < pagination.total_pages) html += `<span class="pagination-info">...</span><button class="pagination-btn" onclick="cargarActividadCompleta(${pagination.total_pages})">${pagination.total_pages}</button>`;
        
        html += `<button class="pagination-btn ${pagination.current_page === pagination.total_pages ? 'disabled' : ''}" onclick="cargarActividadCompleta(${pagination.current_page + 1})">Siguiente</button>`;
        container.innerHTML = html;
    }

    window.revelarTelefono = (elemento, telefono) => {
        if(elemento.classList.contains('telefono-ofuscado')) {
            elemento.classList.remove('telefono-ofuscado');
            elemento.classList.add('telefono-revelado');
            elemento.innerHTML = `${telefono} <a href="https://wa.me/${telefono}" target="_blank" class="ms-2" onclick="event.stopPropagation();"><i class="fab fa-whatsapp" style="color: #25D366;"></i></a>`;
            elemento.title = 'Número revelado';
        }
    };
    window.ofuscarTelefono = (tel) => { if(!tel) return 'N/A'; return tel.length > 8 ? tel.substring(0, 4) + 'XXXX' + tel.substring(tel.length - 3) : 'XXX-XXXX'; };
    window.getColorPorEstado = (estado) => {
        const colores = {
            'nuevo': {bg: 'rgba(108, 117, 125, 0.3)', text: '#ced4da'},
            'por confirmar': {bg: 'rgba(13, 202, 240, 0.3)', text: '#6edff6'},
            'agendado': {bg: 'rgba(253, 126, 20, 0.3)', text: '#fdb44b'},
            'asistido': {bg: 'rgba(25, 135, 84, 0.3)', text: '#75b798'},
            'no contesta': {bg: 'rgba(255, 193, 7, 0.4)', text: '#000'},
            'cancelo': {bg: 'rgba(220, 53, 69, 0.3)', text: '#f1aeb5'},
            'seguimiento': {bg: 'rgba(102, 16, 242, 0.3)', text: '#cda5fe'},
            'no interesado': {bg: 'rgba(33, 37, 41, 0.5)', text: '#adb5bd'}
        };
        return colores[estado] || colores['nuevo'];
    };

    document.getElementById('searchActividadInput').addEventListener('input', () => {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => cargarActividadCompleta(1), 500);
    });

    cargarDashboard();
    setInterval(cargarDashboard, 15000); // Refrescar el dashboard principal
});
</script>

<?php include_once 'templates/footer.php'; ?>