</main> </div> <script>
    function toggleMenu() {
        document.getElementById('pageWrapper').classList.toggle('menu-active');
    }

    function toggleDropdown(id) {
        const allDropdowns = document.querySelectorAll('.dropdown-menus');
        allDropdowns.forEach(menu => {
            if (menu.id !== id) {
                menu.classList.remove('show');
            }
        });
        document.getElementById(id).classList.toggle('show');
    }
    
    function toggleDropdownMobile() { toggleDropdown('userDropdownMobile'); }
    function toggleDropdownDesktop() { toggleDropdown('userDropdownDesktop'); }

    // --- LÓGICA DE CIERRE DE MENÚS MEJORADA ---
    document.addEventListener('click', function(event) {
        // Cierra dropdowns si se hace clic fuera
        const userMenuDesktop = document.querySelector('.ami-header .user-menu');
        if (userMenuDesktop && !userMenuDesktop.contains(event.target)) {
            document.getElementById('userDropdownDesktop').classList.remove('show');
        }
        const userMenuMobile = document.querySelector('.ami-top-bar-mobile .user-menu');
        if (userMenuMobile && !userMenuMobile.contains(event.target)) {
            document.getElementById('userDropdownMobile').classList.remove('show');
        }

        // Cierra el menú lateral en móvil si se hace clic fuera
        const sideMenu = document.getElementById('sideMenu');
        const menuBtn = document.querySelector('.menu-btn');
        if (window.innerWidth <= 768 && sideMenu && menuBtn && !sideMenu.contains(event.target) && !menuBtn.contains(event.target)) {
             document.getElementById('pageWrapper').classList.remove('menu-active');
        }
    });
    
    // --- LÓGICA DE INACTIVIDAD CON TIEMPOS AJUSTADOS ---
    (function() {
        const tiempoEsperaMinutos = 58;  // ✅ CAMBIADO: Alerta a los 58 minutos
        const tiempoCuentaRegresivaSegundos = 120; // ✅ Mantiene 2 minutos (120 segundos)
        let inactividadTimer, cuentaRegresivaInterval;

        function mostrarAvisoInactividad() {
            let segundosRestantes = tiempoCuentaRegresivaSegundos;
            Swal.fire({
                title: '¿Sigues ahí?',
                html: `Tu sesión está a punto de expirar.<br>Se cerrará en <strong>${segundosRestantes}</strong> segundos.`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Permanecer conectado',
                cancelButtonText: 'Cerrar sesión',
                timer: tiempoCuentaRegresivaSegundos * 1000,
                timerProgressBar: true,
                allowOutsideClick: false,
                didOpen: () => {
                    const b = Swal.getHtmlContainer().querySelector('strong');
                    cuentaRegresivaInterval = setInterval(() => { b.textContent = --segundosRestantes; }, 1000);
                },
                willClose: () => { clearInterval(cuentaRegresivaInterval); }
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('/api/keep_alive.php').then(() => resetInactividadTimer());
                } else if (result.dismiss === Swal.DismissReason.timer || result.dismiss === Swal.DismissReason.cancel) {
                    window.location.href = '/includes/logout.php';
                }
            });
        }

        function resetInactividadTimer() {
            clearTimeout(inactividadTimer);
            clearInterval(cuentaRegresivaInterval);
            inactividadTimer = setTimeout(mostrarAvisoInactividad, tiempoEsperaMinutos * 60 * 1000);
        }

        resetInactividadTimer();
        document.addEventListener('click', resetInactividadTimer);
        document.addEventListener('keypress', resetInactividadTimer);
    })();

    // --- SCRIPT GLOBAL Y CORREGIDO PARA CERRAR MODALES ---
    document.addEventListener('mousedown', function (event) {
        let openModal = document.querySelector('.modal.show, .ami-modal.show');
        
        if (openModal && event.target === openModal) {
            
            // Si es un modal de Bootstrap, usa su API para cerrarlo
            try {
                const bsModal = bootstrap.Modal.getInstance(openModal);
                if (bsModal) {
                    bsModal.hide();
                    return;
                }
            } catch (e) {
                // Ignorar si no es un modal de bootstrap
            }

            if (openModal.classList.contains('ami-modal') && typeof ocultarModal === 'function') {
                ocultarModal(openModal.id);
            }
        }
    });

    // --- FUNCIONALIDAD MEJORADA PARA SCROLL DE SIDEBAR ---
    document.addEventListener('DOMContentLoaded', function() {
        const sidebarContainer = document.querySelector('.sidebar-menu-container');
        const activeMenuItem = document.querySelector('.sidebar-menu-container .menu a.active');
        
        if (sidebarContainer) {
            // Función para scrollear al elemento activo
            function scrollToActiveItem() {
                if (activeMenuItem) {
                    // Usar requestAnimationFrame para asegurar que el DOM esté completamente renderizado
                    requestAnimationFrame(() => {
                        activeMenuItem.scrollIntoView({
                            behavior: 'smooth',
                            block: 'center',
                            inline: 'nearest'
                        });
                    });
                }
            }

            // Función para actualizar los efectos de fade
            function updateScrollEffects() {
                const scrollTop = sidebarContainer.scrollTop;
                const scrollHeight = sidebarContainer.scrollHeight;
                const clientHeight = sidebarContainer.clientHeight;
                
                // Mostrar fade superior si no está en la parte superior
                if (scrollTop > 10) {
                    sidebarContainer.classList.add('has-scroll-top');
                } else {
                    sidebarContainer.classList.remove('has-scroll-top');
                }
                
                // Mostrar fade inferior si no está en la parte inferior
                if (scrollTop + clientHeight < scrollHeight - 10) {
                    sidebarContainer.classList.add('has-scroll-bottom');
                } else {
                    sidebarContainer.classList.remove('has-scroll-bottom');
                }
            }

            // Scroll al elemento activo al cargar la página
            scrollToActiveItem();
            
            // Listener para el scroll
            sidebarContainer.addEventListener('scroll', updateScrollEffects);
            
            // Actualizar efectos iniciales
            setTimeout(updateScrollEffects, 100);
            
            // También scrollear cuando se redimensiona la ventana
            window.addEventListener('resize', function() {
                setTimeout(() => {
                    scrollToActiveItem();
                    updateScrollEffects();
                }, 100);
            });
            
            // Guardar posición del scroll en sessionStorage
            const scrollKey = 'sidebar-scroll-position';
            
            // Restaurar posición guardada (solo si no hay elemento activo específico)
            if (!activeMenuItem) {
                const savedScrollPos = sessionStorage.getItem(scrollKey);
                if (savedScrollPos) {
                    sidebarContainer.scrollTop = parseInt(savedScrollPos, 10);
                }
            }
            
            // Guardar posición al hacer scroll
            let scrollTimeout;
            sidebarContainer.addEventListener('scroll', function() {
                clearTimeout(scrollTimeout);
                scrollTimeout = setTimeout(() => {
                    sessionStorage.setItem(scrollKey, sidebarContainer.scrollTop.toString());
                }, 150);
            });
        }
        
        // Mejorar la navegación con teclado
        document.addEventListener('keydown', function(event) {
            if (event.target.closest('.sidebar-menu-container')) {
                const menuLinks = document.querySelectorAll('.sidebar-menu-container .menu a');
                const currentIndex = Array.from(menuLinks).findIndex(link => link === document.activeElement);
                
                if (event.key === 'ArrowDown') {
                    event.preventDefault();
                    const nextIndex = (currentIndex + 1) % menuLinks.length;
                    menuLinks[nextIndex].focus();
                    menuLinks[nextIndex].scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                    });
                } else if (event.key === 'ArrowUp') {
                    event.preventDefault();
                    const prevIndex = currentIndex <= 0 ? menuLinks.length - 1 : currentIndex - 1;
                    menuLinks[prevIndex].focus();
                    menuLinks[prevIndex].scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                    });
                }
            }
        });
    });

    // --- FUNCIÓN PARA SCROLL SUAVE AL ELEMENTO ACTIVO (uso público) ---
    window.scrollToActiveSidebarItem = function() {
        const activeMenuItem = document.querySelector('.sidebar-menu-container .menu a.active');
        if (activeMenuItem) {
            activeMenuItem.scrollIntoView({
                behavior: 'smooth',
                block: 'center',
                inline: 'nearest'
            });
        }
    };
    
    // --- LÓGICA DE NOTIFICACIONES DE MENSAJERÍA ---
    function verificarNuevosMensajes() {
        fetch('/api/memorandos_ajax.php?action=verificar_notificaciones')
            .then(res => res.json())
            .then(data => {
                const badge = document.getElementById('notificacion-mensajes-badge');
                if (badge) {
                    badge.style.display = (data.success && data.data.nuevos_mensajes) ? 'block' : 'none';
                }
            });
    }
    
    // Iniciar la verificación y repetirla cada 30 segundos
    verificarNuevosMensajes();
    setInterval(verificarNuevosMensajes, 30000);

</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</body>
</html>