<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];
$usuario_id = $_SESSION['user_id'] ?? 0;
$rol_usuario = $_SESSION['rol_clave'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

if (!puede('gestionar_afiliaciones_admin')) {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

function get_equipo_ids($conn, $usuario_id, $rol_usuario) {
    if ($rol_usuario === 'superadmin') {
        $stmt = $conn->query("SELECT id FROM usuarios WHERE rol_id = (SELECT id FROM roles WHERE clave = 'operador') AND estado = 1");
    } else {
        $stmt = $conn->prepare("SELECT us.usuario_id FROM usuario_sede us JOIN usuarios u ON us.usuario_id = u.id JOIN roles r ON u.rol_id = r.id WHERE r.clave = 'operador' AND u.estado = 1 AND us.sede_id IN (SELECT sede_id FROM usuario_sede WHERE usuario_id = ?)");
        $stmt->execute([$usuario_id]);
    }
    return $stmt->fetchAll(PDO::FETCH_COLUMN);
}

function telefono_existe($conn, $telefono) {
    $stmt = $conn->prepare("SELECT COUNT(*) FROM gestion_afiliaciones WHERE telefono = ?");
    $stmt->execute([$telefono]);
    return $stmt->fetchColumn() > 0;
}

function insertar_contacto($conn, $nombre, $telefono, $campana, $zona, $origen, $usuario_id) {
    $stmt = $conn->prepare("INSERT INTO gestion_afiliaciones (nombre, telefono, campana, zona, origen, creado_por_id) VALUES (?, ?, ?, ?, ?, ?)");
    return $stmt->execute([$nombre, $telefono, $campana, $zona, $origen, $usuario_id]);
}

switch ($action) {
    case 'cargar_dashboard_admin':
        try {
            $stmt_piscina = $conn->query("SELECT COUNT(*) FROM gestion_afiliaciones WHERE operador_id IS NULL");
            $piscina_count = $stmt_piscina->fetchColumn();

            $sql_operadores = "SELECT DISTINCT u.id, u.nombre FROM usuarios u JOIN roles r ON u.rol_id = r.id ";
            $params_operadores = [];
            if ($rol_usuario !== 'superadmin') {
                $sql_operadores .= "JOIN usuario_sede us ON u.id = us.usuario_id WHERE r.clave = 'operador' AND u.estado = 1 AND us.sede_id IN (SELECT sede_id FROM usuario_sede WHERE usuario_id = ?)";
                $params_operadores[] = $usuario_id;
            } else { $sql_operadores .= " WHERE r.clave = 'operador' AND u.estado = 1"; }
            $sql_operadores .= " ORDER BY u.nombre ASC";
            $stmt_operadores = $conn->prepare($sql_operadores);
            $stmt_operadores->execute($params_operadores);
            $operadores = $stmt_operadores->fetchAll(PDO::FETCH_ASSOC);

            $stmt_lotes = $conn->query("SELECT lote_id, u_op.nombre AS operador_nombre, u_admin.nombre AS admin_nombre, COUNT(ga.id) AS cantidad, MAX(ga.fecha_asignacion) AS fecha_asignacion FROM gestion_afiliaciones ga JOIN usuarios u_op ON ga.operador_id = u_op.id LEFT JOIN usuarios u_admin ON ga.creado_por_id = u_admin.id WHERE ga.lote_id IS NOT NULL GROUP BY ga.lote_id, u_op.nombre, u_admin.nombre ORDER BY MAX(ga.fecha_asignacion) DESC LIMIT 20");
            $lotes = $stmt_lotes->fetchAll(PDO::FETCH_ASSOC);

            $response = ['success' => true, 'data' => ['piscina_count' => $piscina_count, 'operadores' => $operadores, 'lotes' => $lotes]];
        } catch (PDOException $e) { $response['message'] = 'Error al cargar datos: ' . $e->getMessage(); }
        break;

    case 'importar_a_piscina':
        if (isset($_FILES['archivo_csv']) && $_FILES['archivo_csv']['error'] == 0) {
            $handle = fopen($_FILES['archivo_csv']['tmp_name'], "r");
            fgetcsv($handle); // Saltar encabezados
            $importados = 0;
            $fallidos = 0;
            $repetidos = []; // Array para almacenar contactos repetidos
            
            try {
                $conn->beginTransaction();
                
                while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    if (count($data) >= 5 && !empty(trim($data[1]))) {
                        $telefono = trim($data[1]);
                        
                        // Verificar si el teléfono ya existe
                        if (telefono_existe($conn, $telefono)) {
                            // Agregar a lista de repetidos
                            $nombre_repetido = !empty(trim($data[0])) ? trim($data[0]) : 'Sin Nombre';
                            $repetidos[] = [
                                'nombre' => $nombre_repetido,
                                'telefono' => $telefono
                            ];
                            $fallidos++;
                            continue; // Saltar este registro
                        }
                        
                        $nombre = !empty(trim($data[0])) ? trim($data[0]) : 'Sin Nombre';
                        $campana = trim($data[2] ?? '');
                        $zona = trim($data[3] ?? '');
                        $origen = trim($data[4] ?? '');
                        
                        if (insertar_contacto($conn, $nombre, $telefono, $campana, $zona, $origen, $usuario_id)) {
                            $importados++;
                        } else {
                            $fallidos++;
                        }
                    } else {
                        $fallidos++;
                    }
                }
                
                $conn->commit();
                fclose($handle);
                
                registrar_accion('importar_afiliaciones', "Importó {$importados} contactos a la piscina.");
                
                // Preparar la respuesta
                $response = [
                    'success' => true,
                    'message' => "Importación completada. Exitosos: {$importados}, Fallidos: {$fallidos}.",
                    'repetidos' => $repetidos
                ];
                
            } catch (Exception $e) {
                $conn->rollBack();
                fclose($handle);
                $response['message'] = 'Error en importación: ' . $e->getMessage();
            }
        } else {
            $response['message'] = 'Error al subir el archivo.';
        }
        break;

    case 'agregar_manual':
        $nombre = trim($_POST['nombre'] ?? '');
        $telefono = trim($_POST['telefono'] ?? '');
        
        // Si no hay nombre, usar "Sin Nombre"
        if (empty($nombre)) {
            $nombre = 'Sin Nombre';
        }
        
        if (empty($telefono)) {
            $response['message'] = 'El teléfono es obligatorio.';
            break;
        }
        
        try {
            // Verificar si el teléfono ya existe
            if (telefono_existe($conn, $telefono)) {
                $response['message'] = 'El número de teléfono ya existe en la base de datos.';
                break;
            }
            
            $stmt = $conn->prepare("INSERT INTO gestion_afiliaciones (nombre, telefono, campana, origen, creado_por_id) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$nombre, $telefono, trim($_POST['campana'] ?? null), trim($_POST['origen'] ?? null), $usuario_id]);
            registrar_accion('agregar_afiliacion_manual', "Agregó el contacto '{$nombre}' a la piscina.");
            $response = ['success' => true, 'message' => "Se agregó 1 contacto a la piscina."];
        } catch (PDOException $e) {
            $response['message'] = 'Error al guardar: ' . $e->getMessage();
        }
        break;

    case 'asignar_a_operador':
        $operador_id = filter_input(INPUT_POST, 'operador_id', FILTER_VALIDATE_INT); $cantidad = filter_input(INPUT_POST, 'cantidad', FILTER_VALIDATE_INT);
        if (!$operador_id || !$cantidad || $cantidad < 1) { $response['message'] = 'Datos inválidos.'; break; }
        try {
            $conn->beginTransaction();
            $stmt_piscina = $conn->prepare("SELECT id FROM gestion_afiliaciones WHERE operador_id IS NULL ORDER BY fecha_creacion ASC LIMIT :cantidad FOR UPDATE");
            $stmt_piscina->bindParam(':cantidad', $cantidad, PDO::PARAM_INT); $stmt_piscina->execute();
            $ids = $stmt_piscina->fetchAll(PDO::FETCH_COLUMN);
            if (count($ids) < $cantidad) { $conn->rollBack(); $response['message'] = 'No hay suficientes contactos en la piscina. Solo hay ' . count($ids) . ' disponibles.'; break; }
            $lote_id = uniqid('lote_', true);
            $placeholders = implode(',', array_fill(0, count($ids), '?'));
            $stmt_update = $conn->prepare("UPDATE gestion_afiliaciones SET operador_id = ?, fecha_asignacion = NOW(), creado_por_id = ?, lote_id = ? WHERE id IN ($placeholders)");
            $stmt_update->execute(array_merge([$operador_id, $usuario_id, $lote_id], $ids));
            $filas = $stmt_update->rowCount(); $conn->commit();
            registrar_accion('asignar_afiliaciones', "Asignó {$filas} contactos (Lote: {$lote_id}) al operador ID {$operador_id}.");
            $response = ['success' => true, 'message' => "Se asignaron {$filas} contactos."];
        } catch (PDOException $e) { $conn->rollBack(); $response['message'] = 'Error al asignar: ' . $e->getMessage(); }
        break;
        
    case 'get_lote_detalle':
        $lote_id = $_GET['lote_id'] ?? '';
        if (empty($lote_id)) { $response['message'] = 'ID de lote no proporcionado.'; break; }
        try {
            $stmt = $conn->prepare("SELECT nombre, telefono FROM gestion_afiliaciones WHERE lote_id = ?");
            $stmt->execute([$lote_id]);
            $detalles = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $response = ['success' => true, 'data' => $detalles];
        } catch(PDOException $e) { $response['message'] = 'Error al obtener detalles del lote.'; }
        break;

    case 'cargar_monitor_equipo':
        try {
            $equipo_ids = get_equipo_ids($conn, $usuario_id, $rol_usuario);
            if (empty($equipo_ids)) { $response = ['success' => true, 'data' => []]; break; }
            $equipo_data = $conn->query("SELECT id, nombre, foto_perfil FROM usuarios WHERE id IN (".implode(',', $equipo_ids).") ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
            $placeholders = implode(',', array_fill(0, count($equipo_ids), '?'));
            $stmt_stats = $conn->prepare("SELECT operador_id, COUNT(*) as total_asignado, SUM(CASE WHEN estado != 'Pendiente' THEN 1 ELSE 0 END) as gestionados FROM gestion_afiliaciones WHERE operador_id IN ($placeholders) GROUP BY operador_id");
            $stmt_stats->execute($equipo_ids);
            $stats_raw = $stmt_stats->fetchAll(PDO::FETCH_ASSOC);
            $stats_equipo = [];
            foreach($stats_raw as $row) { $stats_equipo[$row['operador_id']] = $row; }
            $stmt_hoy = $conn->prepare("SELECT usuario_id, COUNT(*) as total_hoy FROM bitacora_actividad WHERE usuario_id IN ($placeholders) AND accion = 'actualiza_gestion_afiliacion' AND DATE(fecha) = CURDATE() GROUP BY usuario_id");
            $stmt_hoy->execute($equipo_ids);
            $rendimiento_hoy = $stmt_hoy->fetchAll(PDO::FETCH_KEY_PAIR);
            $stmt_ultima_accion = $conn->prepare("SELECT usuario_id, detalle, fecha FROM bitacora_actividad WHERE id IN (SELECT MAX(id) FROM bitacora_actividad WHERE usuario_id IN ($placeholders) AND accion = 'actualiza_gestion_afiliacion' GROUP BY usuario_id)");
            $stmt_ultima_accion->execute($equipo_ids);
            $ultimas_acciones_raw = $stmt_ultima_accion->fetchAll(PDO::FETCH_ASSOC);
            $ultimas_acciones = [];
            foreach($ultimas_acciones_raw as $row) { $ultimas_acciones[$row['usuario_id']] = $row; }
            $stmt_online = $conn->prepare("SELECT usuario_id, MAX(last_activity) as last_activity FROM sesiones_activas WHERE usuario_id IN ($placeholders) AND is_active = 1 GROUP BY usuario_id");
            $stmt_online->execute($equipo_ids);
            $estados_online = $stmt_online->fetchAll(PDO::FETCH_KEY_PAIR);
            foreach ($equipo_data as &$operador) {
                $id = $operador['id'];
                $stats = $stats_equipo[$id] ?? ['total_asignado' => 0, 'gestionados' => 0];
                $operador['total_asignado'] = (int) $stats['total_asignado'];
                $operador['gestionados'] = (int) $stats['gestionados'];
                $operador['rendimiento_hoy'] = (int) ($rendimiento_hoy[$id] ?? 0);
                $operador['ultima_accion_detalle'] = $ultimas_acciones[$id]['detalle'] ?? 'Sin actividad registrada';
                $operador['ultima_accion_fecha'] = $ultimas_acciones[$id]['fecha'] ?? null;
                $last_activity_str = $estados_online[$id] ?? null;
                $operador['estado_actual'] = 'Offline';
                if ($last_activity_str && (time() - strtotime($last_activity_str)) < 300) { $operador['estado_actual'] = 'Online'; }
            }
            $response = ['success' => true, 'data' => $equipo_data];
        } catch (PDOException $e) { $response['message'] = 'Error al cargar monitor: ' . $e->getMessage(); }
        break;

    case 'get_operador_live_feed':
        $operador_id = filter_input(INPUT_GET, 'operador_id', FILTER_VALIDATE_INT);
        if (!$operador_id) { $response['message'] = 'ID de operador no válido.'; break; }
        try {
            $stmt = $conn->prepare("SELECT detalle, fecha FROM bitacora_actividad WHERE usuario_id = ? AND accion = 'actualiza_gestion_afiliacion' ORDER BY id DESC LIMIT 30");
            $stmt->execute([$operador_id]);
            $feed = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $response = ['success' => true, 'data' => $feed];
        } catch (PDOException $e) { $response['message'] = 'Error al cargar feed: ' . $e->getMessage(); }
        break;

    case 'cargar_reporte_pap':
        try {
            $equipo_ids = get_equipo_ids($conn, $usuario_id, $rol_usuario);
            if(empty($equipo_ids)) { $response = ['success' => true, 'data' => []]; break; }
            $placeholders = implode(',', array_fill(0, count($equipo_ids), '?'));
            $sql = "SELECT u.id as operador_id, u.nombre as operador_nombre, COUNT(ga.id) as total_pap FROM usuarios u LEFT JOIN gestion_afiliaciones ga ON u.id = ga.operador_id AND ga.origen = 'PaP' WHERE u.id IN ($placeholders) GROUP BY u.id, u.nombre ORDER BY u.nombre ASC";
            $stmt_reporte = $conn->prepare($sql);
            $stmt_reporte->execute($equipo_ids);
            $reporte = $stmt_reporte->fetchAll(PDO::FETCH_ASSOC);
            $response = ['success' => true, 'data' => $reporte];
        } catch (PDOException $e) { $response['message'] = 'Error al cargar reporte PaP: ' . $e->getMessage(); }
        break;
        
    case 'get_reporte_pap_detalle':
        $operador_id = filter_input(INPUT_GET, 'operador_id', FILTER_VALIDATE_INT);
        if (!$operador_id) { $response['message'] = 'ID de operador no válido.'; break; }
        try {
            $stmt = $conn->prepare("SELECT nombre, telefono, estado, fecha_ultimo_contacto, observaciones FROM gestion_afiliaciones WHERE operador_id = ? AND origen = 'PaP' ORDER BY fecha_ultimo_contacto DESC");
            $stmt->execute([$operador_id]);
            $detalles = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $response = ['success' => true, 'data' => $detalles];
        } catch (PDOException $e) { $response['message'] = 'Error al cargar detalles del reporte: ' . $e->getMessage(); }
        break;

    case 'get_analiticas':
        try {
            $equipo_ids = get_equipo_ids($conn, $usuario_id, $rol_usuario);
            if(empty($equipo_ids)) { $response = ['success' => true, 'data' => ['ranking' => [], 'origen_volumen' => [], 'origen_efectividad' => []]]; break; }
            $placeholders = implode(',', array_fill(0, count($equipo_ids), '?'));

            // Ranking
            $stmt_ranking = $conn->prepare("SELECT u.nombre, u.foto_perfil, COUNT(ga.id) as total_gestionados, SUM(CASE WHEN ga.estado = 'Afiliado' THEN 1 ELSE 0 END) as total_afiliados FROM gestion_afiliaciones ga JOIN usuarios u ON ga.operador_id = u.id WHERE ga.operador_id IN ($placeholders) AND ga.estado != 'Pendiente' GROUP BY u.id, u.nombre, u.foto_perfil ORDER BY total_afiliados DESC, total_gestionados DESC");
            $stmt_ranking->execute($equipo_ids);
            $ranking = $stmt_ranking->fetchAll(PDO::FETCH_ASSOC);

            // Origen Volumen
            $stmt_origen_vol = $conn->prepare("SELECT origen, COUNT(*) as total FROM gestion_afiliaciones WHERE operador_id IN ($placeholders) AND origen IS NOT NULL AND origen != '' GROUP BY origen ORDER BY total DESC");
            $stmt_origen_vol->execute($equipo_ids);
            $origen_volumen = $stmt_origen_vol->fetchAll(PDO::FETCH_ASSOC);
            
            // Origen Efectividad
            $stmt_origen_ef = $conn->prepare("SELECT origen, SUM(CASE WHEN estado = 'Afiliado' THEN 1 ELSE 0 END) as afiliados, COUNT(*) as total FROM gestion_afiliaciones WHERE operador_id IN ($placeholders) AND origen IS NOT NULL AND origen != '' AND estado != 'Pendiente' GROUP BY origen");
            $stmt_origen_ef->execute($equipo_ids);
            $origen_efectividad_raw = $stmt_origen_ef->fetchAll(PDO::FETCH_ASSOC);
            $origen_efectividad = array_map(function($item) {
                $item['tasa_cierre'] = ($item['total'] > 0) ? round(($item['afiliados'] / $item['total']) * 100, 2) : 0;
                return $item;
            }, $origen_efectividad_raw);
            usort($origen_efectividad, function($a, $b) { return $b['tasa_cierre'] <=> $a['tasa_cierre']; });

            $response = ['success' => true, 'data' => ['ranking' => $ranking, 'origen_volumen' => $origen_volumen, 'origen_efectividad' => $origen_efectividad]];
        } catch (PDOException $e) { $response['message'] = 'Error al generar analíticas: ' . $e->getMessage(); }
        break;

    default:
        $response['message'] = 'Acción de gestión desconocida.';
        break;
}

echo json_encode($response);