<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];
$usuario_id = $_SESSION['user_id'] ?? 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'actualizar_cliente_reactivacion':
        $reactivacion_id = filter_input(INPUT_POST, 'reactivacion_id', FILTER_VALIDATE_INT);
        $estado_nuevo = $_POST['estado'] ?? '';
        $accion_nueva = $_POST['ultima_accion'] ?? '';
        $nota_adicional = trim($_POST['notas'] ?? '');

        if (!$reactivacion_id || empty($estado_nuevo)) {
            $response['message'] = 'Faltan datos para actualizar el cliente.';
            break;
        }

        try {
            $conn->beginTransaction();

            $stmt_check = $conn->prepare("SELECT notas, estado_contacto, cliente_id FROM reactivacion_clientes WHERE id = ? AND operador_id = ?");
            $stmt_check->execute([$reactivacion_id, $usuario_id]);
            $cliente_actual = $stmt_check->fetch(PDO::FETCH_ASSOC);

            if (!$cliente_actual) {
                $conn->rollBack();
                $response['message'] = 'No tienes permiso para modificar este cliente.';
                break;
            }

            $estado_anterior = $cliente_actual['estado_contacto'];
            $cliente_id = $cliente_actual['cliente_id'];

            // --- NUEVA LÓGICA DE CANCELACIÓN ---
            if ($estado_anterior === 'Agendado' && $estado_nuevo !== 'Agendado') {
                $stmt_delete = $conn->prepare(
                    "DELETE jc FROM jornada_clientes jc
                     JOIN jornadas j ON jc.jornada_id = j.id
                     WHERE jc.cliente_id = ? AND j.fecha_jornada >= CURDATE()"
                );
                $stmt_delete->execute([$cliente_id]);
                $nota_adicional .= "\n[Sistema: Eliminado de la jornada por cambio de estado de reactivación]";
            }

            $notas_para_guardar = $cliente_actual['notas'];
            if (!empty($nota_adicional)) {
                $notas_para_guardar .= "\n---\n[" . date('Y-m-d H:i:s') . "]\n" . $nota_adicional;
            }

            $stmt_update = $conn->prepare("UPDATE reactivacion_clientes SET estado_contacto = ?, ultima_accion = ?, notas = ?, fecha_ultima_llamada = NOW() WHERE id = ?");
            $stmt_update->execute([$estado_nuevo, $accion_nueva, $notas_para_guardar, $reactivacion_id]);
            
            $conn->commit();
            registrar_accion('actualiza_cliente_reactivacion', "Actualizó estado del cliente de reactivación ID: {$reactivacion_id} a '{$estado_nuevo}'");
            $response = ['success' => true, 'message' => 'Cliente de reactivación actualizado.'];

        } catch (PDOException $e) {
            $conn->rollBack();
            $response['message'] = 'Error de base de datos al actualizar: ' . $e->getMessage();
            error_log($e->getMessage());
        }
        break;

    case 'agendar_cliente_reactivacion':
        $cliente_id = filter_input(INPUT_POST, 'cliente_id', FILTER_VALIDATE_INT);
        $reactivacion_id = filter_input(INPUT_POST, 'reactivacion_id', FILTER_VALIDATE_INT);
        $jornada_id = filter_input(INPUT_POST, 'jornada_id', FILTER_VALIDATE_INT);
        $cedula = trim($_POST['cedula'] ?? '');
        $edad = filter_input(INPUT_POST, 'edad', FILTER_VALIDATE_INT);
        $sexo = in_array($_POST['sexo'] ?? '', ['M', 'F']) ? $_POST['sexo'] : null;
        $hora_asistencia = $_POST['hora_asistencia'] ?? null;

        if (!$cliente_id || !$reactivacion_id || !$jornada_id || empty($cedula) || !$edad || !$hora_asistencia || !$sexo) {
            $response['message'] = 'Faltan datos para agendar al cliente (Cédula, Edad, Sexo, Jornada, Hora).';
            break;
        }
        try {
            $conn->beginTransaction();

            $stmt_cliente = $conn->prepare("
                SELECT c.* FROM clientes c
                JOIN reactivacion_clientes rc ON c.id = rc.cliente_id
                WHERE c.id = ? AND rc.id = ? AND rc.operador_id = ?
            ");
            $stmt_cliente->execute([$cliente_id, $reactivacion_id, $usuario_id]);
            $cliente = $stmt_cliente->fetch(PDO::FETCH_ASSOC);

            if (!$cliente) {
                $conn->rollBack();
                $response['message'] = 'Cliente no encontrado o no tienes permiso sobre él.';
                break;
            }

            $stmt_update_cliente = $conn->prepare("UPDATE clientes SET cedula = ?, edad = ? WHERE id = ?");
            $stmt_update_cliente->execute([$cedula, $edad, $cliente_id]);

            $stmt_check_agenda = $conn->prepare("SELECT id FROM jornada_clientes WHERE jornada_id = ? AND cliente_id = ?");
            $stmt_check_agenda->execute([$jornada_id, $cliente_id]);
            if ($stmt_check_agenda->fetch()) {
                $conn->rollBack();
                $response['message'] = 'Este cliente ya está agendado en la jornada seleccionada.';
                break;
            }

            $stmt_agendar = $conn->prepare("INSERT INTO jornada_clientes (jornada_id, cliente_id, agendado_por_operador_id, hora_asistencia, edad, sexo, estado_cita) VALUES (?, ?, ?, ?, ?, ?, 'Agendado')");
            $stmt_agendar->execute([$jornada_id, $cliente_id, $usuario_id, $hora_asistencia, $edad, $sexo]);

            $stmt_update_reactivacion = $conn->prepare("UPDATE reactivacion_clientes SET estado_contacto = 'Agendado' WHERE id = ?");
            $stmt_update_reactivacion->execute([$reactivacion_id]);
            
            $conn->commit();
            registrar_accion('agendamiento_reactivacion', "El operador agendó al cliente ID {$cliente_id} (Reactivación ID {$reactivacion_id}) a la jornada ID {$jornada_id}.");
            $response = ['success' => true, 'message' => '¡Cliente de reactivación agendado correctamente!'];

        } catch (Exception $e) {
            $conn->rollBack();
            $response['message'] = 'Error en el proceso de agendamiento: ' . $e->getMessage();
            error_log("Error en agendar_cliente_reactivacion: " . $e->getMessage());
        }
        break;

    default:
        $response['message'] = 'Acción de reactivación desconocida.';
        break;
}

echo json_encode($response);
?>