<?php
// 1. Cargar el entorno de seguridad completo.
// Esto nos da acceso a la sesión, la conexión a la BD y la función registrar_accion().
require_once '../administracion/includes/seguridad.php';

// 2. Antes de destruir la sesión, obtenemos sus datos para el registro.
if (isset($_SESSION['user_id'])) {
    $session_id_actual = session_id();
    
    try {
        // 3. (LÓGICA CLAVE) Marcar la sesión como inactiva en la base de datos.
        // No la eliminamos, solo la "apagamos" para mantener el historial.
        $stmt_deactivate = $conn->prepare(
            "UPDATE sesiones_activas SET is_active = 0, estado = 'cerrada' WHERE session_id = ?"
        );
        $stmt_deactivate->execute([$session_id_actual]);
        
        // 4. (Bitácora Mejorada) Usar la función centralizada para registrar el evento.
        registrar_accion('logout_manual', 'El usuario cerró sesión voluntariamente.');

    } catch (PDOException $e) {
        // Registrar cualquier error que pueda ocurrir durante el proceso de cierre de sesión en la BD.
        error_log("Error al desactivar sesión en logout.php: " . $e->getMessage());
    }
}

// 5. Ahora sí, destruir la sesión de PHP.
session_unset();
session_destroy();

// 6. Redirigir al login.
header("Location: ../login");
exit();
?>